// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// mdebug.cc:
//
// original new and delete for memory debug 
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/mdebug.cc,v 1.5 1994/07/14 09:04:11 kudou Exp $

extern "C"
{
#include <stdlib.h>
#include <stdio.h>
}

#include "config.h"
#include "typedef.h"
#include "mdebug.h"

static long count = 0;

#ifndef NOMDEBUG
const int mid_alloc = 0x1234;
const int mid_free  = 0x4321;

struct mid
{
  int id;
  size_t size;
};

void*
operator new (size_t size)
{
  count ++;
  void* p = calloc(1, size + sizeof(mid));
  if (p == 0)
  {
    fprintf(stderr, "no memory. malloc() returns null.");
    exit(1);
  }
  mid* m = (mid*)p;
  m->id = mid_alloc;
  m->size = size;
  return ((char*)p) + sizeof(mid);
}

void
operator delete (void* p)
{
  if (p)
  {
    count --;
    mid* m = (mid*)((char*)p - sizeof (mid));
    if (m->id != mid_alloc)
    {
      if (m->id == mid_free)
      {
	fprintf(stderr, "memory is already deleted! %p", p);
      }
      else
      {
	fprintf(stderr, "delete unknown memory! %p", p);
      }
      exit(1);
    }
    m->id = mid_free;
    char* f = (char*)p;
    for (size_t i = 0; i < m->size; i++)
    {
      *f++ = 0xff;
    }
#ifdef CHAR_P_MALLOC_T
    free((char*)m);
#else
    free((void*)m);
#endif
  }
}
#endif

long
get_memory_count()
{
  return count;
}

// end of mdebug.cc
