// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// mem.cc:
//
// class Mem
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/mem.cc,v 1.5 1994/05/02 14:46:49 kudou Exp $

#include "mem.h"

extern "C"
{
#include <stdlib.h>
#include <string.h>
#include <assert.h>
}

Mem::Mem (size_t size)
{
  Mem::size = size;
  mem = malloc (size);
  assert (mem != 0);
}

Mem::Mem (Mem& m)
{
  size = m.size;
  mem = malloc (size);
  assert (mem != 0);
  memcpy (mem, m.mem, size);
}

Mem::~Mem ()
{
  if (mem != 0)
  {
    free (mem);
  }
}

void Mem::Expand (size_t size)
{
  mem = realloc (mem, size);
  assert (mem != 0);
  Mem::size = size;
}

void Mem::Shrink (size_t /*size*/)
{
  ; // do nothing now
}
