// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xalist.cc:
//
// eXogenous(OI) Array List
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xalist.cc,v 1.3 1994/05/02 14:46:49 kudou Exp $

extern "C"
{
#include <stdlib.h>
#include <string.h>
}

#include "config.h"
#include "xalist.h"

// -------------------------------------------------------------------- //
// class _XAList ̃\bh
// -------------------------------------------------------------------- //
inline void
_XAList::CheckBufferSize (unsigned int new_size)
{
  new_size++;   // ݂͂̕
  if (new_size > buffer_size)
  {
    buffer = (void* (*)[])realloc (
#ifdef CHAR_P_MALLOC_T
				   (char*)buffer,
#else
				   buffer, 
#endif
                  (size_t) (sizeof (void*) * (new_size + extra_realloc_size)));
    buffer_size = new_size + extra_realloc_size;
  }
}

_XAList::_XAList ()
{
  buffer = (void* (*)[])malloc (sizeof (void*) * default_initial_buffer_size);
  buffer_size = default_initial_buffer_size;
  used_size = 0;
}

_XAList::_XAList (unsigned int initial_buffer_size)
{
  initial_buffer_size++;	// ݂͂̕
  buffer = (void* (*)[])malloc (sizeof (void*) * initial_buffer_size);
  buffer_size = initial_buffer_size;
  used_size = 0;
}

_XAList::_XAList (_XList& l)
{
  if (l.GetXListID () == _XAListID)
  {
    _XAList& apl = (_XAList&)l;
    buffer = (void* (*)[])malloc (sizeof (void*) * apl.buffer_size);
    memcpy (buffer, apl.buffer, sizeof (void*) * apl.used_size);
    buffer_size = apl.buffer_size;
    used_size = apl.used_size;
  }
  else
  {
    buffer = (void* (*)[])malloc (sizeof (void*) * default_initial_buffer_size);
    buffer_size = default_initial_buffer_size;
    used_size = 0;
    _XList::operator = (l);
  }
}

_XAList::~_XAList ()
{
#ifdef CHAR_P_MALLOC_T
  free ((char*)buffer);
#else
  free ((void*)buffer);
#endif
}

void
_XAList::operator = (_XList& l)
{
  if (l.GetXListID () == _XAListID)
  {
    _XAList& apl = (_XAList&)l;
    Clear ();
    CheckBufferSize (apl.used_size);
    memcpy (buffer, apl.buffer, sizeof (void*) * apl.used_size);
    used_size = apl.used_size;
  }
  else
  {
    _XList::operator = (l);
  }
}

_XListID
_XAList::GetXListID ()
{
  return _XAListID;
}

bool
_XAList::EmptyP ()
{
  return (used_size == 0) ? True : False;
}

unsigned int
_XAList::Number ()
{
  return used_size;
}

void*
_XAList::Access (unsigned int n)
{
  // 1 <= n <= used_size
  return ((n == 0) || (n > used_size)) ? 0 : (*buffer)[n - 1];
}

void*
_XAList::operator [] (unsigned int n)
{
  // 0 <= n < used_size
  return (n >= used_size) ? 0 : (*buffer)[n];
}

void*
_XAList::Prev (void* item)
{
  (*buffer)[used_size] = item;
  for (unsigned int n = 0; (*buffer)[n] != item; n ++)
  {
    ;
  }
  return ((n == used_size) || (n == 0)) ? 0 : (*buffer)[n - 1];
}

void*
_XAList::Next (void* item)
{
  (*buffer)[used_size] = item;
  for (unsigned int n = 0; (*buffer)[n] != item; n++)
  {
    ;
  }
  return (n >= used_size - 1) ? 0 : (*buffer)[n + 1];
}

void*
_XAList::Head ()
{
  return (used_size == 0) ? 0 : (*buffer)[0];
}

void*
_XAList::Tail ()
{
  return (used_size == 0) ? 0 : (*buffer)[used_size - 1];
}

void
 _XAList::Push (void* item)
{
  CheckBufferSize (used_size + 1);
  memmove (& (*buffer)[1], & (*buffer)[0], sizeof (void*) * used_size);
  (*buffer)[0] = item;
  used_size ++;
}

void*
_XAList::Pop ()
{
  void* ret = (*buffer)[0];
  used_size --;
  memmove (& (*buffer)[0], & (*buffer)[1], sizeof (void*) * used_size);
  return ret;
}

void
_XAList::Inject (void* item)
{
  CheckBufferSize (used_size + 1);
  (*buffer)[used_size++] = item;
}

void*
_XAList::Eject ()
{
  return (*buffer)[--used_size];
}

void
_XAList::InsertBefore (void* item, unsigned int pos)
{
  if (pos > used_size)
  {
    return;
  }
  CheckBufferSize (used_size + 1);
  memmove (& (*buffer)[pos], & (*buffer)[pos - 1], 
           sizeof (void*) * ((used_size + 1) - pos));
  (*buffer)[pos - 1] = item;
  used_size ++;
}

void 
_XAList::InsertBefore (void* item, void* pos)
{
  (*buffer)[used_size] = item;
  for (unsigned int n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n >= used_size)
  {
    return;
  }
  CheckBufferSize (used_size + 1);
  memmove (& (*buffer)[n + 1], & (*buffer)[n], 
           sizeof (void*) * (used_size - n));
  (*buffer)[n] = item;
  used_size ++;
}

void
_XAList::InsertAfter (void* item, unsigned int pos)
{
  if (pos > used_size)
  {
    return;
  }
  CheckBufferSize (used_size + 1);
  memmove (& (*buffer)[pos + 1], & (*buffer)[pos], 
           sizeof (void*) * (used_size - pos));
  (*buffer)[pos] = item;
  used_size ++;
}

void
_XAList::InsertAfter (void* item, void* pos)
{
  (*buffer)[used_size] = item;
  for (unsigned int n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n >= used_size)
  {
    return;
  }
  CheckBufferSize (used_size + 1);
  memmove (& (*buffer)[n + 2], & (*buffer)[n + 1], 
           sizeof (void*) * (used_size - (n + 1)));
  (*buffer)[n + 1] = item;
  used_size ++;
}

void
_XAList::Delete (void* pos)
{
  (*buffer)[used_size] = pos;
  for (unsigned int n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n < used_size)
  {
    memmove (& (*buffer)[n], & (*buffer)[n + 1], 
	     sizeof (void*) * (used_size - n - 1));
    used_size --;
  }
}

void
_XAList::Delete (unsigned int pos)
{
  if (pos > used_size)
  {
    return;
  }
  memmove (& (*buffer)[pos - 1], & (*buffer)[pos], 
           sizeof (void*) * (used_size - pos));
  used_size --;
}

void
_XAList::Clear ()
{
  used_size = 0;
}

void
_XAList::ExchangeItem (void* item, unsigned int pos)
{
  if (used_size < pos)
  {
    return;
  }
  (*buffer)[pos - 1] = item;
}

void
_XAList::ExchangeItem (void* item, void* pos)
{
  (*buffer)[used_size] = pos;
  for (unsigned int n = 0; (*buffer)[n] != pos; n++)
  {
    ;
  }
  if (n < used_size)
  {
    (*buffer)[n] = item;
  }
}

void
_XAList::SwapItem (void* i1, void* i2)
{
  (*buffer)[used_size] = i1;
  for (unsigned int n1 = 0; (*buffer)[n1] != i1; n1++)
  {
    ;
  }
  (*buffer)[used_size] = i2;
  for (unsigned int n2 = 0; (*buffer)[n2] != i2; n2++)
  {
    ;
  }
  if ((n1 < used_size) && (n2 < used_size))
  {
    void* swap_buf = (*buffer)[n1];
    (*buffer)[n1] = (*buffer)[n2];
    (*buffer)[n2] = swap_buf;
  }
}

void
_XAList::SwapItem (unsigned int n1, unsigned int n2)
{
  if ((n1 > used_size) || (n2 > used_size))
  {
    return;
  }
  void* swap_buf = (*buffer)[n1 - 1];
  (*buffer)[n1 - 1] = (*buffer)[n2 -1];
  (*buffer)[n2 - 1] = swap_buf;
}

#ifndef NODEBUG
void _XAList::Show ()
{
  
}
#endif

// -------------------------------------------------------------------- //
// class _XAListIterator ̃\bh
// -------------------------------------------------------------------- //
_XAListIterator::_XAListIterator (_XList* l)
: _XListIterator (l)
{
  pos = 0;
}

_XAListIterator::_XAListIterator (_XList& l)
: _XListIterator (l)
{
  pos = 0;
}

void*
_XAListIterator::operator () ()
{
  if (id == _XAListID)
  {
    if (pos >= ((_XAList*)l)->used_size)
    {
      return 0;
    }
    else
    {
      return (* ((_XAList*)l)->buffer)[pos++];
    }
  }
  else
  {
    // Ώۂ _XAList łȂ
    return _XListIterator::operator () ();
  }
}

void
_XAListIterator::Revert ()
{
  if (id == _XAListID)
  {
    pos = 0;
  }
  else
  {
    // Ώۂ _XAList łȂ
    _XListIterator::Revert ();
  }
}
