// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xdlist.h:
//
// eXogenous(OI) Double List
//
// class _XDList	void* version
// class XDList<T>	template version
// class GXDList(T)	generic macro version
//
//              +----------------------------------+
//              v                                  |
// sentinel -->[-]<-->[*]<-->[*]<-...->[*]<-->[*]<-+
//                   ŏ                    Ō
//
// iterator
// class _XDListIterator
// class XDListIterator<T>
// class GXDListIterator(T)
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xdlist.h,v 1.3 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_xdlist_h
#define _leaf_xdlist_h

#include "typedef.h"
#include "xlist.h"

class _XDListNode; // forword ref.

// oXgAXgwbh
class _XDList 
: public _XList 
{
  // ݂͂
  _XDListNode* sentinel;
  
  // ߂̃m[h̎o
  // return           : ŏ̃m[h
  _XDListNode* GetFirst ();
  
  // Ō̃m[h̎o
  // return           : Ō̃m[h
  _XDListNode* GetLast ();
  
 public:
  // RXgN^
  _XDList ();
  
  // Rs[RXgN^
  _XDList (_XList& l);
  
  // fXgN^
  ~_XDList ();
  
  // ۃNXpo
#  include "xlistm.h"
  
  friend class _XDListIterator;
};

class _XDListIterator 
: public _XListIterator 
{
  // C^[g̃m[h
  _XDListNode* node;
  
 public:
  // RXgN^
  // l                 : C^[g
  _XDListIterator (_XList* l);
  
  // RXgN^
  // l                 : C^[g
  _XDListIterator (_XList& l);
  
  // ۃNXpo
#  include "xlisti.h"
};

#ifdef HAS_TEMPLATE
template <class T>
class XDList
{
  friend class XDListIterator<T>; 
  _XDList dpl;

 public:
  XDList() : dpl() { ; }
  XDList(_XList& sl) : dpl(sl) { ; }
  XDList(XDList<T>& sl) : dpl(sl.dpl) { ; }
  ~XDList() { ; }
  operator _XList& () { return dpl; }
  void operator = (XDList<T>& l) { dpl = l.dpl; }
  bool EmptyP() { return dpl.EmptyP(); }
  unsigned int Number() { return dpl.Number(); }
  T* Access(unsigned int n) { return (T*)dpl.Access(n); }
  T* operator [] (unsigned int n) { return (T*)dpl.Access(n + 1); }
  T* Prev(T* item) { return (T*)dpl.Prev(item); }
  T* Next(T* item) { return (T*)dpl.Next(item); }
  T* Head() { return (T*)dpl.Head(); }
  T* Tail() { return (T*)dpl.Tail(); }
  void Push(T* item) { dpl.Push(item); }
  T* Pop() { return (T*)dpl.Pop(); }
  void Inject(T* item) { dpl.Inject(item); }
  T* Eject() { return (T*)dpl.Eject(); }
  void InsertBefore(T* item, unsigned int pos) 
    { dpl.InsertBefore(item, pos); }
  void InsertBefore(T* item, T* pos)
    { dpl.InsertBefore(item, pos); }
  void InsertAfter(T* item, unsigned int pos)
    { dpl.InsertAfter(item, pos); }
  void InsertAfter(T* item, T* pos)
    { dpl.InsertAfter(item, pos); }
  void Delete(T* pos) { dpl.Delete(pos); }
  void Delete(unsigned int pos) { dpl.Delete(pos); }
  void Clear() { dpl.Clear(); }
  void ExchangeItem(T* item, unsigned int pos)
    { dpl.ExchangeItem(item, pos); }
  void ExchangeItem(T* item, T* pos)
    { dpl.ExchangeItem(item, pos); }
  void SwapItem(T* i1, T* i2)
    { dpl.SwapItem(i1, i2); }
  void SwapItem(unsigned int n1, unsigned int n2)
    { dpl.SwapItem(n1, n2); }
};

template <class T>
class XDListIterator
{
  _XDListIterator dpli; 
 public:
  XDListIterator(_XList* l) : dpli(l) { ; }
  XDListIterator(_XList& l) : dpli(l) { ; }
  XDListIterator(XDList<T>* l) : dpli(l->dpl) { ; }
  T* operator () () { return (T*)dpli(); }
  void Revert() { dpli.Revert(); }
};

#endif

#include "generic.h"

// NX̒`
#define GXDList(T) name2(GXDList_,T)
#define GXDListIterator(T) name2(GXDListIterator_,T)

// NX錾
// ̃}N^ɂēWJ邱ƂŐNX`
// e\bhɂĂ̎dl _XDList, _XList ̃NXQƂ̂
#define GXDListDeclare(T)						\
class GXDList(T)							\
{									\
  _XDList dpl;								\
 public:								\
  GXDList(T)() : dpl() { ; }						\
  GXDList(T)(_XList& sl) : dpl(sl) { ; }				\
  GXDList(T)(GXDList(T)& sl) : dpl(sl.dpl) { ; }			\
  ~GXDList(T)() { ; }							\
  operator _XList& () { return dpl; }					\
  void operator = (GXDList(T)& l) { dpl = l.dpl; }			\
  bool EmptyP() { return dpl.EmptyP(); }				\
  unsigned int Number() { return dpl.Number(); }			\
  T* Access(unsigned int n) { return (T*)dpl.Access(n); }		\
  T* operator [] (unsigned int n) { return (T*)dpl.Access(n + 1); }	\
  T* Prev(T* item) { return (T*)dpl.Prev(item); }			\
  T* Next(T* item) { return (T*)dpl.Next(item); }			\
  T* Head() { return (T*)dpl.Head(); }					\
  T* Tail() { return (T*)dpl.Tail(); }					\
  void Push(T* item) { dpl.Push(item); }				\
  T* Pop() { return (T*)dpl.Pop(); }					\
  void Inject(T* item) { dpl.Inject(item); }				\
  T* Eject() { return (T*)dpl.Eject(); }				\
  void InsertBefore(T* item, unsigned int pos) 				\
    { dpl.InsertBefore(item, pos); }					\
  void InsertBefore(T* item, T* pos)					\
    { dpl.InsertBefore(item, pos); }					\
  void InsertAfter(T* item, unsigned int pos)				\
    { dpl.InsertAfter(item, pos); }					\
  void InsertAfter(T* item, T* pos)					\
    { dpl.InsertAfter(item, pos); }					\
  void Delete(T* pos) { dpl.Delete(pos); }				\
  void Delete(unsigned int pos) { dpl.Delete(pos); }			\
  void Clear() { dpl.Clear(); }						\
  void ExchangeItem(T* item, unsigned int pos)				\
    { dpl.ExchangeItem(item, pos); }					\
  void ExchangeItem(T* item, T* pos)					\
    { dpl.ExchangeItem(item, pos); }					\
  void SwapItem(T* i1, T* i2)						\
    { dpl.SwapItem(i1, i2); }						\
  void SwapItem(unsigned int n1, unsigned int n2)			\
    { dpl.SwapItem(n1, n2); }						\
  friend class GXDListIterator(T); 					\
};									\
									\
class GXDListIterator(T) 						\
{									\
  _XDListIterator dpli;							\
 public:								\
  GXDListIterator(T)(_XList* l) : dpli(l) { ; }				\
  GXDListIterator(T)(_XList& l) : dpli(l) { ; }				\
  GXDListIterator(T)(GXDList(T)* l) : dpli(l->dpl) { ; }		\
  T* operator () () { return (T*)dpli(); }				\
  void Revert() { dpli.Revert(); }					\
};

#endif /* _leaf_xdlist_h */
