// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// edit.cpp:
//
// EditWnd sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/sample/edit/RCS/edit.cpp,v 1.15 1994/05/09 16:31:07 kudou Exp $

#include "lw.h"
#include "edit.h"

// class Edit
Edit::Edit ()
{
  edit_wnd = 0;
}

Edit::~Edit ()
{
  delete edit_wnd;
}

LPSTR
Edit::GetCaptionStr ()
{
  return "Edit";
}

void
Edit::OpenChildWindow ()
{
  edit_wnd = new EditWnd (this);
  edit_wnd->OpenWindow ();
  status_wnd = new StatusWnd (this);
  status_wnd->OpenWindow ();
}

void
Edit::Resize (WORD left, WORD top, WORD right, WORD bottom)
{
  WORD bar_height = GetStatusWnd () ? GetStatusWnd ()->GetBarHeight () : 0;
  if (GetEditWnd ())
  {
    GetEditWnd ()->MoveWindow (border_size,
			       border_size,
			       right - left - border_size,
			       bottom - top - border_size - bar_height);
  }
  if (GetStatusWnd ())
  {
    GetStatusWnd ()->MoveWindow (border_size,
				 bottom - top - border_size - bar_height,
				 right - left - border_size,
				 bottom - top - border_size);
  }
}

void 
Edit::SetFocus ()
{
  if (edit_wnd)
  {
    edit_wnd->SetFocus ();
  }
}

LPSTR
Edit::GetMenuName ()
{
  return "EditMenu";
}

void
Edit::Update ()
{
  Wnd::Update ();
  edit_wnd->UpdateCaption ();
}

long
Edit::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_COMMAND:
    if ((wparam == WndID_EditWnd) && 
	(edit_wnd->GetHandle () ==  LOWORD (lparam)))
    {
      return edit_wnd->WindowProc (msg, wparam, lparam);
    }
    else
    {
      Menu (wparam, lparam);
    }
    break;

   case WM_MENUSELECT:
    MenuSelect (wparam);
    break;

   case WM_CLOSE:
    if (edit_wnd->CloseFile (0))
    {
      ::DestroyWindow (GetHandle ());
    }
    break;

   default:
    return BaseWnd::WindowProc (msg, wparam, lparam);
  }
  return 1;
}

void 
Edit::Display (HDC hdc)
{
  DisplayGrayFrame (hdc, border_size);
}

void
Edit::MenuSelect (WPARAM wparam)
{
  switch (wparam)
  {
   case MENU_ID_FILE_OPEN:
   case MENU_ID_FILE_SAVE:
   case MENU_ID_FILE_SAVE_AS:
   case MENU_ID_FILE_EXIT:
   case MENU_ID_EDIT_UNDO:
   case MENU_ID_EDIT_CUT:
   case MENU_ID_EDIT_COPY:
   case MENU_ID_EDIT_PASTE:
   case MENU_ID_EDIT_DELETE:
   case MENU_ID_HELP_ABOUT:
    status_wnd->StrIdPrintf (wparam + MHELP_OFFSET);
    break;
    
   default:
    status_wnd->ClearMsg ();
    break;
  }
}

uword
Edit::Menu (WPARAM wparam, LPARAM lparam)
{
  uword ret = MF_ENABLED;
  bool menu_state = (lparam == GET_MENU_STATE);
  
  switch (wparam)
  {
    // file menu
   case MENU_ID_FILE_OPEN:
    ret = edit_wnd->OpenFile (menu_state);
    break;
   
   case MENU_ID_FILE_SAVE:
    ret = edit_wnd->SaveFile (menu_state);
    break;
   
   case MENU_ID_FILE_SAVE_AS:
    ret = edit_wnd->SaveAsFile (menu_state);
    break;
   
   case MENU_ID_FILE_EXIT:
    ret = edit_wnd->CloseFile (menu_state);
    if (!menu_state && ret)
    {
      ret = BaseWnd::Exit (menu_state);
    }
    break;
   
    // edit menu
   case MENU_ID_EDIT_UNDO:
    ret = edit_wnd->UndoEdit (menu_state);
    break;
    
   case MENU_ID_EDIT_CUT:
    ret = edit_wnd->CutEdit (menu_state);
    break;
    
   case MENU_ID_EDIT_COPY:
    ret = edit_wnd->CopyEdit (menu_state);
    break;
    
   case MENU_ID_EDIT_PASTE:
    ret = edit_wnd->PasteEdit (menu_state);
    break;
    
   case MENU_ID_EDIT_DELETE:
    ret = edit_wnd->DeleteEdit (menu_state);
    break;
        
   case MENU_ID_HELP_ABOUT:
    ret = BaseWnd::About (menu_state);
    break;
    
   default:
    break;
  }
  return ret;
}

int
Main ()
{
  Edit wnd;
  wnd.OpenWindow ();
  return MSWin::MessageLoop ();
}
