// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mdiedit.h:
//
// MDI editor sample
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/sample/mdiedit/RCS/mdiedit.h,v 1.6 1994/05/14 14:10:33 kudou Exp $

#ifndef _mdiedit_h
#define _mdiedit_h

class EditDoc;	// forword ref.

class MdiEdit
: public MdiFrameWnd
{
  enum { border_size = 6 };
  StatusWnd* status_wnd;
  ToolBarWnd* toolbar_wnd;
  EditDoc* docs;
  EditDoc* current_doc;
  PrivateProfile profile;
  uword serial_doc_num;
  enum { max_edit_doc = 10 };
  
 protected:
  // replacement
  virtual HANDLE GetIcon ();
  virtual LPSTR GetCaptionStr ();
  virtual void OpenChildWindow ();
  virtual void SetFocus ();
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual void Display(HDC hdc);
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void Close ();
  virtual void Destroy ();
  virtual LPSTR GetMenuName ();
  virtual uword Menu (WPARAM wparam, LPARAM lparam);
  void MenuSelect (WPARAM wparam);
  
  virtual HMENU GetWindowMenu ();
  uword NewFile (bool menu_state);
  uword OpenFile (bool menu_state);
  uword SaveFile (bool menu_state);
  uword SaveAsFile (bool menu_state);
  uword CloseFile (bool menu_state);
  uword UndoEdit (bool menu_state);
  uword CutEdit (bool menu_state);
  uword CopyEdit (bool menu_state);
  uword PasteEdit (bool menu_state);
  uword DeleteEdit (bool menu_state);
  uword CascadeWin (bool menu_state);
  uword ArrangeWin (bool menu_state);
  uword TileWin (bool menu_state);

 public:
  MdiEdit ();
  ~MdiEdit ();
  StatusWnd* GetStatusWnd () { return status_wnd; }
  ToolBarWnd* GetToolBarWnd () { return toolbar_wnd; }
  MdiChildWnd* OpenMdiChildWindow ();
  void SetCurrentEditDoc (EditDoc* current) { current_doc = current; }
  uword GetEditDocNumber ();
  void RemoveEditDoc (EditDoc* edit_doc);
};

class EditDoc
: public MdiChildWnd
{
  EditWnd* edit_wnd;
  EditDoc* next;

 public:
  EditDoc (MdiEdit* mdi_edit, EditDoc* next = 0);
  ~EditDoc ();
  EditWnd* GetEditWnd () { return edit_wnd; }
  MdiEdit* GetMdiEdit () { return (MdiEdit*)GetMdiFrameWnd (); }
  EditDoc* GetNext () { return next; }
  void SetNext (EditDoc* n) { next = n; }

 protected:
  virtual LPSTR GetCaptionStr ();
  virtual DWORD GetCreateWindowStyle ();
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual void OpenChildWindow ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);

 public:
  virtual void SetFocus ();
};

const WORD window_menu_pos = 2;

#define MENU_ID_FILE_NEW	1101
#define MENU_ID_FILE_OPEN	1102
#define MENU_ID_FILE_SAVE	1103
#define MENU_ID_FILE_SAVE_AS	1104
#define MENU_ID_FILE_CLOSE	1105
#define MENU_ID_FILE_EXIT	1106
#define MENU_ID_EDIT_UNDO	1201
#define MENU_ID_EDIT_CUT	1202
#define MENU_ID_EDIT_COPY	1203
#define MENU_ID_EDIT_PASTE	1204
#define MENU_ID_EDIT_DELETE	1205
#define MENU_ID_WIN_CASCADE	1301
#define MENU_ID_WIN_ARRANGE	1302
#define MENU_ID_WIN_TILE	1303
#define MENU_ID_HELP_ABOUT	1401

#define MENU_MSG_OFFSET		1000
#define MSG_ID_FILE_NEW		MENU_ID_FILE_NEW + MENU_MSG_OFFSET
#define MSG_ID_FILE_OPEN	MENU_ID_FILE_OPEN + MENU_MSG_OFFSET
#define MSG_ID_FILE_SAVE	MENU_ID_FILE_SAVE + MENU_MSG_OFFSET
#define MSG_ID_FILE_SAVE_AS	MENU_ID_FILE_SAVE_AS + MENU_MSG_OFFSET
#define MSG_ID_FILE_CLOSE	MENU_ID_FILE_CLOSE + MENU_MSG_OFFSET
#define MSG_ID_FILE_EXIT	MENU_ID_FILE_EXIT + MENU_MSG_OFFSET
#define MSG_ID_EDIT_UNDO	MENU_ID_EDIT_UNDO + MENU_MSG_OFFSET
#define MSG_ID_EDIT_CUT		MENU_ID_EDIT_CUT + MENU_MSG_OFFSET
#define MSG_ID_EDIT_COPY	MENU_ID_EDIT_COPY + MENU_MSG_OFFSET
#define MSG_ID_EDIT_PASTE	MENU_ID_EDIT_PASTE + MENU_MSG_OFFSET
#define MSG_ID_EDIT_DELETE	MENU_ID_EDIT_DELETE + MENU_MSG_OFFSET
#define MSG_ID_WIN_CASCADE	MENU_ID_WIN_CASCADE + MENU_MSG_OFFSET
#define MSG_ID_WIN_ARRANGE	MENU_ID_WIN_ARRANGE + MENU_MSG_OFFSET
#define MSG_ID_WIN_TILE		MENU_ID_WIN_TILE + MENU_MSG_OFFSET
#define MSG_ID_HELP_ABOUT	MENU_ID_HELP_ABOUT + MENU_MSG_OFFSET

#endif /* _mdiedit_h */
