// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mdisamp.cpp:
//
// MDI sample
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/sample/mdisamp/RCS/mdisamp.cpp,v 1.5 1994/05/14 13:21:35 kudou Exp $

#include "lw.h"
#include "mdisamp.h"

MdiSample::MdiSample ()
{
  status_wnd = 0;
}

MdiSample::~MdiSample ()
{
  delete status_wnd;
}

void
MdiSample::Display (HDC hdc)
{
  DisplayGrayFrame (hdc, border_size);
}

void
MdiSample::Resize (WORD left, WORD top, WORD right, WORD bottom)
{
  WORD caption_height = GetStatusWnd ()->GetBarHeight ();
  GetMdiClientWnd ()->MoveWindow (border_size,
				  border_size,
				  right - left - border_size,
				  bottom - top - border_size - caption_height);
  GetStatusWnd ()->MoveWindow (border_size,
			       bottom - top - border_size - caption_height,
			       right - left - border_size,
			       bottom - top - border_size);
}

void
MdiSample::OpenChildWindow ()
{
  status_wnd = new StatusWnd (this);
  status_wnd->OpenWindow ();
  MdiFrameWnd::OpenChildWindow ();
}

LPSTR 
MdiSample::GetCaptionStr ()
{
  return "MdiSample";
}

LPSTR
MdiSample::GetMenuName ()
{
  return "MdiSampleMenu";
}

MdiChildWnd*
MdiSample::OpenMdiChildWindow ()
{
  MdiChildWnd* mdi_child_wnd = new MdiChildWnd (this);
  mdi_child_wnd->OpenWindow ();
  return mdi_child_wnd;
}

uword
MdiSample::Menu (WPARAM wparam, LPARAM lparam)
{
  uword ret = MF_ENABLED;
  bool menu_state = (lparam == GET_MENU_STATE);
  
  switch (wparam)
  {
   case MENU_ID_OPEN:
    if (!menu_state)
    {
      OpenMdiChildWindow ();
    }
    break;
    
   case MENU_ID_EXIT:
    ret = BaseWnd::Exit (menu_state);
    break;

   case MENU_ID_ABOUT:
    ret = BaseWnd::About (menu_state);
    break;

   case MENU_ID_CASCADE:
    ret = Cascade (menu_state);
    break;
    
   case MENU_ID_ARRANGE:
    ret = Arrange (menu_state);
    break;

   case MENU_ID_TILE:
    ret = Tile (menu_state);
    break;

   default:
    if (!menu_state)
    {
      return ::DefFrameProc (GetHandle (), GetMdiClientHandle (),
			     WM_COMMAND, wparam, lparam);
    }
    break;
  }
  return ret;
}

uword
MdiSample::Cascade (bool menu_state)
{
  if (menu_state)
  {
    return MF_ENABLED;
  }
  ::SendMessage (GetMdiClientHandle (), WM_MDICASCADE, 0, 0L);
  return 0;
}

uword
MdiSample::Arrange (bool menu_state)
{
  if (menu_state)
  {
    return MF_ENABLED;
  }
  ::SendMessage (GetMdiClientHandle (), WM_MDIICONARRANGE, 0, 0L);
  return 0;
}

uword
MdiSample::Tile (bool menu_state)
{
  if (menu_state)
  {
    return MF_ENABLED;
  }
  ::SendMessage (GetMdiClientHandle (), WM_MDITILE, 0, 0L);
  return 0;
}

HMENU
MdiSample::GetWindowMenu ()
{
  const WORD window_menu_pos = 1;
  return ::GetSubMenu (::GetMenu(GetHandle ()), window_menu_pos);
}

int
Main ()
{
  MdiSample wnd;
  wnd.OpenWindow ();
  return MSWin::MessageLoop ();
}
