// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// simple.cpp:
//
// simple window sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/1/lw/sample/simple/RCS/simple.cpp,v 1.7 1994/07/17 14:51:44 kudou Exp $

#include "lw.h"
#include "simple.h"
#include <math.h>

LPSTR
Simple::GetCaptionStr ()
{
  return "Simple";
}

void 
Simple::Display (HDC hdc)
{
  int x_size = GetWindowXSize (); 
  int y_size = GetWindowYSize ();

  const double pi = 3.14159265;
  const double delta = pi / 250.0;
  
  int px = x_size / 2;
  int py = y_size / 2;
  int wx = x_size * 2 / 5;
  int wy = y_size * 2 / 5;
  int x1, y1, x2, y2;
  for (double a = 0.0; a < pi; a += delta)
  {
    x1 = px - wx * cos (0.8 * a);
    y1 = py - wy * sin (7.0 * a) * cos (a / 2.5);
    x2 = px - wx * cos (1.2 * a);
    y2 = y1;
    ::MoveTo (hdc, x1, y1);
    ::LineTo (hdc, x2, y2);
  }
}

int
Main ()
{
  Simple wnd;
  wnd.OpenWindow ();
  return MSWin::MessageLoop ();
}
