// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// basewnd.cpp:
//
// class BaseWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/basewnd.cpp,v 1.9 1994/05/09 16:31:31 kudou Exp $

#include "lw.h"

// -------------------------------------------------------------------- //
// class AboutDlg
// -------------------------------------------------------------------- //
class AboutDlg
: public ModalDlg
{
 public:
  AboutDlg (VWin* parent) : ModalDlg ("AboutDlg", parent) { }
};

// -------------------------------------------------------------------- //
// class ExitDlg
// -------------------------------------------------------------------- //
class ExitDlg
: public ModalDlg
{
 public:
  ExitDlg (VWin* parent) : ModalDlg ("ExitDlg", parent) { }
};

// -------------------------------------------------------------------- //
// class BaseWnd
// -------------------------------------------------------------------- //
static char* win_class_name = "BaseWnd_WndV20";
bool BaseWnd::register_flag = False;

LPSTR
BaseWnd::GetClassName ()
{
  return win_class_name;
}

WNDPROC
BaseWnd::GetWindowProc ()
{
  return ::WindowProc;
}

LPSTR
BaseWnd::GetMenuName ()
{
  return NULL;
}

HANDLE
BaseWnd::GetCursor ()
{
  return ::LoadCursor (NULL, IDC_ARROW);
}

HANDLE
BaseWnd::GetIcon ()
{
  return ::LoadIcon (NULL, IDI_APPLICATION);
}

UINT
BaseWnd::GetStyle ()
{
  return CS_HREDRAW | CS_VREDRAW;
}

LPSTR
BaseWnd::GetCaptionStr ()
{
  return "BaseWnd";
}

DWORD
BaseWnd::GetCreateWindowStyle ()
{
  return (WS_OVERLAPPEDWINDOW | WS_MAXIMIZEBOX | WS_MINIMIZEBOX);
}

int
BaseWnd::GetCreateWindowXPos ()
{
  return CW_USEDEFAULT;
}

int
BaseWnd::GetCreateWindowYPos ()
{
  return 0;
}

int
BaseWnd::GetCreateWindowXSize ()
{
  return CW_USEDEFAULT;
}

int
BaseWnd::GetCreateWindowYSize ()
{
  return 0;
}

HWND
BaseWnd::GetParent ()
{
  return 0;
}

void
BaseWnd::OpenChildWindow ()
{
  ;
}

bool
BaseWnd::RegisterFlag ()
{
  return register_flag;
}

void
BaseWnd::SetRegisterFlag ()
{
  register_flag = True;
}

void 
BaseWnd::RegisterClass ()
{
  if (RegisteredP ())
  {
    return;
  }
  WNDCLASS wcClass;
  wcClass.lpszClassName = GetClassName ();
  wcClass.hInstance     = MSWin::GetInstance ();
  wcClass.lpfnWndProc   = GetWindowProc ();
  wcClass.hCursor       = GetCursor ();
  wcClass.hIcon         = GetIcon ();
  wcClass.lpszMenuName  = GetMenuName ();
  wcClass.hbrBackground = GetStockObject (WHITE_BRUSH);
  wcClass.style         = GetStyle ();
  wcClass.cbClsExtra    = 0;
  wcClass.cbWndExtra    = sizeof (Wnd*);
  ::RegisterClass (&wcClass);
  SetRegisterFlag ();
}

BaseWnd::BaseWnd ()
{
}

BaseWnd::~BaseWnd ()
{
}

void 
BaseWnd::OpenWindow ()
{
  RegisterClass ();
  SetHandle (::CreateWindow (GetClassName (),
			     GetCaptionStr (),
			     GetCreateWindowStyle (),
			     GetCreateWindowXPos (),
			     GetCreateWindowYPos (),
			     GetCreateWindowXSize (),
			     GetCreateWindowYSize (),
			     GetParent (),
			     NULL,
			     MSWin::GetInstance (),
			     (LPSTR) this));
  OpenChildWindow ();
  Update ();
}

void 
BaseWnd::InitMenu (HMENU h_menu)
{
  if (h_menu)
  {
    int mn = ::GetMenuItemCount (h_menu);
    for (int n = 0; n < mn; n++)
    {
      int m_id = ::GetMenuItemID (h_menu, n);
      uword new_state = Menu (m_id, GET_MENU_STATE);
      uword old_state = (::GetMenuState (h_menu, m_id, MF_BYCOMMAND)
			 & (MF_DISABLED | MF_GRAYED |
			    MF_CHECKED | MF_UNCHECKED));
      if (old_state != new_state)
      {
	if ((new_state & (MF_CHECKED | MF_UNCHECKED)) != 
	    (old_state & (MF_CHECKED | MF_UNCHECKED))) 
	{
	  ::CheckMenuItem (h_menu, m_id, MF_BYCOMMAND | new_state);
	}
	if ((new_state & (MF_ENABLED | MF_DISABLED | MF_GRAYED)) != 
	    (old_state & (MF_ENABLED | MF_DISABLED | MF_GRAYED))) 
	{
	  ::EnableMenuItem (h_menu, m_id, MF_BYCOMMAND | new_state);
	}
      }
    }
  }
}

long 
BaseWnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_PAINT:
    {
      Paint p (GetHandle ());
      Display (p);
    }
    break;

   case WM_INITMENUPOPUP:
    {
      InitMenu ((HMENU)wparam);
      return 0; // never return 1;
    }

   case WM_COMMAND:
    Menu (wparam, lparam);
    break;
    
   default:
    return Wnd::WindowProc (msg, wparam, lparam);
  }
  return 0L;
}

void
BaseWnd::Display (Paint& pnt) 
{
  Display (pnt.GetDC ());
}

void
BaseWnd::Display (HDC /*hdc*/)
{
}

void
BaseWnd::DisplayGrayFrame (HDC hdc, int border_size)
{
  int x_size = GetWindowXSize ();
  int y_size = GetWindowYSize ();

  RECT rec;
  rec.left = 0;
  rec.top = 0;
  rec.right = x_size;
  rec.bottom = y_size;
  ::FillRect (hdc, &rec, ::GetStockObject (LTGRAY_BRUSH));
  
  // white
  HPEN pen = ::CreatePen (PS_SOLID, 1, GetSysColor(COLOR_BTNSHADOW));
  HPEN old_pen = ::SelectObject (hdc, pen);
  ::MoveTo (hdc, border_size - 1, y_size - border_size - 1);
  ::LineTo (hdc, border_size - 1, border_size - 1);
  ::LineTo (hdc, x_size - border_size - 1, border_size - 1);
  // dark gray
  ::SelectObject (hdc, old_pen);
  ::DeleteObject (pen);
  pen = ::CreatePen (PS_SOLID, 1, RGB(0xff, 0xff, 0xff));
  ::SelectObject (hdc, pen);
  ::LineTo (hdc, x_size - border_size - 1, y_size - border_size - 1);
  ::LineTo (hdc, border_size - 1, y_size - border_size - 1);
  ::SelectObject (hdc, old_pen);
  ::DeleteObject (pen);
}

uword
BaseWnd::Menu (WPARAM wparam, LPARAM lparam)
{
  return 0;
}

uword 
BaseWnd::Exit (bool menu_state)
{
  if (menu_state)
  {
    return MF_ENABLED;
  }
  ExitDlg dlg (this);
  if (dlg.Go ())
  {
    ::PostQuitMessage (0);	
  }
  return 0;
}

uword 
BaseWnd::About (bool menu_state)
{
  if (menu_state)
  {
    return MF_ENABLED;
  }
  AboutDlg dlg (this);
  dlg.Go ();
  return 0;
}
