// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// comm.cpp:
//
// class Comm
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/comm.cpp,v 1.2 1994/05/05 16:17:37 kudou Exp $

#include "lw.h"

Comm::Comm ()
{
  port_number = DefaultPortNumber;
  comm_id = 0;
  open_p = False;
  notify_wnd = 0;
  use_cn_receive_p = True;
  
  baud_rate = CBR_9600;
  byte_size = 8;
  stop_bits = ONESTOPBIT;
  parity = NOPARITY;
  flow = None;
}

Comm::~Comm ()
{
  Close ();
}

bool
Comm::ChangeSetup ()
{
  if (!OpenP ())
  {
    return False;
  }
  DCB dcb;
  ::GetCommState (comm_id, &dcb);
  dcb.BaudRate = GetBaudRate ();
  dcb.ByteSize = GetByteSize ();
  dcb.Parity = GetParity ();
  dcb.StopBits = GetStopBits ();
  dcb.fOutxDsrFlow = dcb.fDtrflow = DTR_DSRFlowControlP ();
  dcb.DsrTimeout = DTR_DSRFlowControlP () ? 30 : 0 ;
  dcb.fOutxCtsFlow = dcb.fRtsflow = RTS_CTSFlowControlP ();
  dcb.CtsTimeout = RTS_CTSFlowControlP () ? 30 : 0 ;
  dcb.fInX = dcb.fOutX = XFlowControlP ();
  dcb.XonChar = XonChar;
  dcb.XoffChar = XoffChar;
  dcb.XonLim = 100 ;
  dcb.XoffLim = 100 ;
  dcb.fBinary = True;
  dcb.fParity = True;
  dcb.fRtsDisable = False;
  dcb.fDtrDisable = False;
  dcb.fNull = True;
  if (::SetCommState(&dcb) < 0)
  {
    notify_wnd->MessageBoxPrintf ("SetCommState Error", "TTY", MB_OK);
    ::CloseComm (GetCommId ());
    return False;
  }
  return True;
}

bool
Comm::Open (Wnd* wnd)
{
  if (open_p)
  {
    return True;
  }
  notify_wnd = wnd;
  open_p = False;
  static char* comm_name_tbl[] = { "com1", "com2", "com3", "com4", };
  char* comm_name = comm_name_tbl [(port_number < 3) ? port_number : 0];
  comm_id = ::OpenComm (comm_name, InQueueSize, OutQueueSize);
  if (comm_id < 0)
  {
    wnd->MessageBoxPrintf ("Open Error: %04x", comm_name, MB_OK, comm_id);
    return False;
  }
  open_p = True;
  if (!ChangeSetup ())
  {
    return False;
  }
  if (UseCnReceiveP ())
  {
    ::EnableCommNotification (GetCommId (), wnd->GetHandle (),
			      MaxBlockSize, -1);
  }
  else
  {
    ::SetCommEventMask (GetCommId (), EV_RXCHAR);
    ::EnableCommNotification (GetCommId (), wnd->GetHandle (), -1, -1);
  }
  ::EscapeCommFunction (GetCommId (), SETDTR);
  return True;
}

bool
Comm::Close ()
{
  if (open_p)
  {
    if (notify_wnd)
    {
      ::EnableCommNotification (notify_wnd->GetHandle (), NULL, -1, -1);
    }
    ::EscapeCommFunction (GetCommId (), CLRDTR);
    ::CloseComm (GetCommId ()) ;
    open_p = False;
  }
  return True;
}

int
Comm::Write (const char* buf, int size)
{
  return ::WriteComm (GetCommId (), (char*)buf, size);
}

int
Comm::Read (char* buf, int buf_size)
{
  return ::ReadComm (GetCommId (), buf, buf_size);
}

UINT
Comm::GetReciveQueCharSize ()
{
  COMSTAT stat;
  ::GetCommError (GetCommId (), &stat);
  return stat.cbInQue;
}

UINT
Comm::GetSendQueCharSize ()
{
  COMSTAT stat;
  ::GetCommError (GetCommId (), &stat);
  return stat.cbOutQue;
}

BYTE
Comm::GetTransStatus ()
{
  COMSTAT stat;
  ::GetCommError (GetCommId (), &stat);
  return stat.status;
}

int
Comm::GetCommError ()
{
  COMSTAT stat;
  return ::GetCommError (GetCommId (), &stat);
}
