// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// comm.h:
//
// class Comm
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/comm.h,v 1.1 1994/05/05 16:12:07 kudou Exp $

#ifndef _leaf_comm_h
#define _leaf_comm_h

#include "lw.h"

class Comm
{
  int port_number;
  int comm_id;
  bool open_p;
  Wnd* notify_wnd;
  bool use_cn_receive_p;
  
  WORD baud_rate;
  BYTE byte_size;
  BYTE stop_bits;
  BYTE parity;
  enum Flow
  {
    None,
    XFlow,
    DTR_DSR,
    RTS_CTS,
  } flow;
  
 public:
  enum
  {
    InQueueSize = 4096,
    OutQueueSize = 4096,
    MaxBlockSize = 80,
    XonChar = 0x11,
    XoffChar = 0x13,
    DefaultPortNumber = 1,
  }; 

 public:
  Comm ();
  ~Comm ();

  void SetPortNumber (int p) { port_number = p; }
  int GetPortNumber () const { return port_number; }
  void SetUseCnReceive (bool p) { use_cn_receive_p = p; }
  bool UseCnReceiveP () const { return use_cn_receive_p; }
    
  // comm id
  int GetCommId () { return comm_id; }
  
  // baud rate. 300/1200/2400/4800/9600/19200 or
  // CBR_110/CBR_300/CBR_600/CBR_1200/CBR_2400/CBR_4800/CBR_9600
  // CBR_14400/CBR_19200/CBR_38400/CBR_56000/CBR_128000/CBR_256000
  void SetBaudRate (WORD baud) { baud_rate = baud; }
  WORD GetBaudRate () const { return baud_rate; }

  // size. 7 / 8
  void SetByteSize (BYTE b) { byte_size = b; }
  BYTE GetByteSize () const { return byte_size; }

  // parity. NOPARITY / ODDPARITY / EVENPARITY / MARKPARITY
  void SetParity (BYTE p) { parity = p; }
  BYTE GetParity () const { return parity; }

  // stop bits. ONESTOPBIT / ONE5STOPBITS / TWOSTOPBITS
  void SetStopBits (BYTE s) { stop_bits = s; }
  BYTE GetStopBits () const { return stop_bits; }

  // flow control
  void SetXFlowControl () { flow = XFlow; }
  void SetDTR_DSRFlowControl () { flow = DTR_DSR; }
  void SetRTS_CTSFlowControl () { flow = RTS_CTS; }
  void SetHardFlowControl () { SetRTS_CTSFlowControl (); }
  void SetNornFlowControl () { flow = None; }
  bool XFlowControlP () const { return flow == XFlow; }
  bool DTR_DSRFlowControlP () const { return flow == DTR_DSR; }
  bool RTS_CTSFlowControlP () const { return flow == RTS_CTS; }
  bool HardFlowControlP () const { return RTS_CTSFlowControlP (); }
  bool NornFlowControlP () const { return flow == None; }

  bool ChangeSetup ();
  bool Open (Wnd* notify_wnd);
  bool Close ();
  bool OpenP () { return open_p; }

  // write data
  // return > 0 : write data size
  // return < 0 : error, abs(return): write data size
  int Write (const char* buf, int size);
  
  // read data
  // return : read data size
  // return < 0 : error, abs(return): read data size
  int Read (char* buf, int buf_size);

  UINT GetReciveQueCharSize ();
  UINT GetSendQueCharSize ();
  
  // see SDK COMSTAT.status document
  BYTE GetTransStatus ();
  
  // return : see SDK GetCommError return value
  int GetCommError ();
};

#endif /* _leaf_comm_h */
