/* -------------------------------------------------------------------- */
/*                     Leaf class library for Windows			*/
/*           Copyright (c) 1993-4 by T.Kudou. All rights reserved.	*/
/*									*/
/* lw.h:								*/
/*									*/
/* include all basic classes						*/
/* -------------------------------------------------------------------- */
/* $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/lw.h,v 1.15 1994/05/08 16:36:14 kudou Exp $ */

#ifndef _lw_lw_h
#define _lw_lw_h

#include "typedef.h"

#include <windows.h>
#include <commdlg.h>

#define beep() MessageBeep (1)

CFUNC void syserr (char *format, ...);

const uword max_path_length = 256;
#define GET_MENU_STATE 0x0001

#ifdef __cplusplus
#include "mswin.h"
#include "wnd.h"
#include "paint.h"
#include "basewnd.h"
#include "dlg.h"
#include "editwnd.h"
#include "filename.h"
#include "statwnd.h"
#include "mdi.h"
#include "accel.h"
#include "rstr.h"
#include "profile.h"
#include "toolbar.h"
#include "textwnd.h"
#include "comm.h"
#include "termwnd.h"
#endif

// this library ID uses from 20000 to 29999
#define WndID_EditWnd	             25001
#define WndID_MdiClientWnd           25002
#define WndID_MdiChildWnd            25501
// don't use from WndID_MdiChildWnd to WndID_MdiChildWndMax as new id
#define WndID_MdiChildWndMax         25999

#define StrID_EditWnd_CantOpen       26001
#define StrID_EditWnd_Err            26002
#define StrID_EditWnd_LessMemory     26003
#define StrID_EditWnd_MaxText        26004
#define StrID_EditWnd_ReadError      26005
#define StrID_EditWnd_ReadLessMemory 26006
#define StrID_EditWnd_TooBig         26007
#define StrID_EditWnd_SaveOpenErr    26008
#define StrID_EditWnd_SaveAsOpenErr  26009
#define StrID_EditWnd_DefaultFileName 26010
#define StrID_EditWnd_DefaultMdiFileName 26011
#define StrID_EditWnd_CloseFileMsg   26012

#endif /* _lw_lw_h */
