// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mswin.h:
//
// class MSWin
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/mswin.h,v 1.7 1994/05/08 16:43:41 kudou Exp $

#ifndef _lw_mswin_h
#define _lw_mswin_h

int Main (void);

class MSWin
{
  static HANDLE instance;
  static HANDLE prev_instance;
  static LPSTR cmd_line;
  static int cmd_show;
  
 public:
  // constructor
  // instance	  : instance handle
  // prev_instance: prev. instance handle
  // cmd_show	  : show
  MSWin (HANDLE instance, HANDLE prev_instance, LPSTR cmd_line, int cmd_show);

  // message loop
  // return	: WinMain return value
  static int MessageLoop ();
  
  // one message action
  static bool OneMessage ();
  
  static HANDLE GetInstance () { return instance; }
  static HANDLE GetPrevInstance () { return prev_instance; }
  static LPSTR GetCmdLine () { return cmd_line; }
  static int GetCmdShow () { return cmd_show; }
  static void GetExecPath (char* path, uword size);
  static HACCEL LoadAccelerators (LPCSTR accel_name)
  {
    return ::LoadAccelerators (instance, accel_name);
  }
  static HBITMAP LoadBitmap (LPCSTR bitmap_name)
  {
    return ::LoadBitmap (instance, bitmap_name);
  }
  static HCURSOR LoadCursor (LPCSTR cursor_name)
  {
    return ::LoadCursor (instance, cursor_name);
  }
  static HICON LoadIcon (LPCSTR icon_name)
  {
    return ::LoadIcon (instance, icon_name);
  }
  static HMENU LoadMenu (LPCSTR menu_name)
  {
    return ::LoadMenu (instance, menu_name);
  }
  static int LoadString (UINT id, LPSTR buf, int buf_size)
  {
    return ::LoadString (instance, id, buf, buf_size);
  }
};

#endif /* _lw_mswin_h */
