// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// profile.cpp:
//
// struct ProfileEntry
// class PrivateProfile
// class Profile
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/profile.cpp,v 1.1 1994/04/17 12:08:26 kudou Exp $

#include "lw.h"
#include <string.h>
#include <stdlib.h>

// -------------------------------------------------------------------- //
// class InternalProfileEntry
// -------------------------------------------------------------------- //
void
InternalProfileEntry::Get (char* section, char* filename)
{
  ::GetPrivateProfileString (section,
			     name,
			     default_content,
			     content,
			     entry_buf_size,
			     filename);
}

void
InternalProfileEntry::Write (char* section, char* filename)
{
  ::WritePrivateProfileString (section,
			       name,
			       content,
			       filename);
}

// -------------------------------------------------------------------- //
// class PrivateProfile
// -------------------------------------------------------------------- //
PrivateProfile::PrivateProfile (char* section, 
				char* filename,
				ProfileEntry* init_entrys)
{
  PrivateProfile::section = section;
  PrivateProfile::filename = filename;
  entrys = 0;
  for (ProfileEntry* entry = init_entrys;
       entry->name != 0;
       entry ++)
  {
    entrys = new InternalProfileEntry (entry->name,
				       entry->default_content,
				       entry->id,
				       entrys);
  }
  Get ();
}

PrivateProfile::~PrivateProfile ()
{
  Write ();
  InternalProfileEntry* e = entrys;
  while (e != 0)
  {
    InternalProfileEntry* next = e->GetNext ();
    delete e;
    e = next;
  }
  entrys = 0;
}

void
PrivateProfile::Get ()
{
  for (InternalProfileEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    e->Get (section, filename);
  }
}

void
PrivateProfile::Write ()
{
  for (InternalProfileEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    e->Write (section, filename);
  }
}

InternalProfileEntry*
PrivateProfile::GetInternalEntry (char* entry)
{
  for (InternalProfileEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    if (!strcmp (entry, e->GetName ()))
    {  
      break;
    }
  }
  return e;
}

InternalProfileEntry*
PrivateProfile::GetInternalEntry (int id)
{
  for (InternalProfileEntry* e = entrys;
       e != 0;
       e = e->GetNext ())
  {
    if (id == e->GetID ())
    {
      break;
    }
  }
  return e;
}

char*
PrivateProfile::GetEntry (char* entry)
{
  InternalProfileEntry* e = GetInternalEntry (entry);
  return e ? e->GetContent () : "";
}

char*
PrivateProfile::GetEntry (int id)
{
  InternalProfileEntry* e = GetInternalEntry (id);
  return e ? e->GetContent () : "";
}

int
PrivateProfile::GetEntryInt (char* entry)
{
  InternalProfileEntry* e = GetInternalEntry (entry);
  return e ? atoi (e->GetContent ()) : 0;
}

int
PrivateProfile::GetEntryInt (int id)
{
  InternalProfileEntry* e = GetInternalEntry (id);
  return e ? atoi (e->GetContent ()) : 0;
}

bool
PrivateProfile::SetEntry (char* entry, char* content)
{
  InternalProfileEntry* e = GetInternalEntry (entry);
  if (e)
  {
    strncpy (e->GetContent (), content, InternalProfileEntry::entry_buf_size);
    return True;
  }
  return False;
}

bool
PrivateProfile::SetEntry (int id, char* content)
{
  InternalProfileEntry* e = GetInternalEntry (id);
  if (e)
  {
    strncpy (e->GetContent (), content, InternalProfileEntry::entry_buf_size);
    return True;
  }
  return False;
}

bool
PrivateProfile::SetEntryInt (char* entry, int content)
{
  InternalProfileEntry* e = GetInternalEntry (entry);
  if (e)
  {
    wsprintf (e->GetContent (), "%d", content);
    return True;
  }
  return False;
}

bool
PrivateProfile::SetEntryInt (int id, int content)
{
  InternalProfileEntry* e = GetInternalEntry (id);
  if (e)
  {
    wsprintf (e->GetContent (), "%d", content);
    return True;
  }
  return False;
}

// -------------------------------------------------------------------- //
// class Profile
// -------------------------------------------------------------------- //
Profile::Profile (char* section, ProfileEntry* init_entrys)
: PrivateProfile (section, "WIN.INI", init_entrys)
{
  ;
}

Profile::~Profile ()
{
  ;
}

