// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// statwnd.cpp:
//
// class StatusWnd
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/statwnd.cpp,v 1.4 1994/04/17 13:37:58 kudou Exp $

#include "lw.h"
#include <stdarg.h>
#include <string.h>

bool StatusWnd::register_flag = False;

StatusWnd::StatusWnd (Wnd* parent)
{
  bar_height = ::GetSystemMetrics (SM_CYCAPTION);
  StatusWnd::parent = parent;
  msg[0] = '\0';
}

StatusWnd::~StatusWnd ()
{
}

bool
StatusWnd::RegisterFlag ()
{
  return register_flag;
}

LPSTR
StatusWnd::GetClassName ()
{
  return "StatusWnd_WndV20";
}

UINT
StatusWnd::GetStyle ()
{
  return CS_HREDRAW | CS_VREDRAW;
}

DWORD
StatusWnd::GetCreateWindowStyle ()
{
  return WS_CHILD;
}

HWND
StatusWnd::GetParent ()
{
  return parent->GetHandle ();
}

void
StatusWnd::Display (HDC hdc)
{
  int x_size = GetWindowXSize ();
  int y_size = GetWindowYSize ();
  RECT rec;
  rec.left = 0;
  rec.top = 0;
  rec.right = x_size;
  rec.bottom = y_size;
  ::FillRect (hdc, &rec, ::GetStockObject (LTGRAY_BRUSH));
  int old_bk_mode = ::SetBkMode (hdc, TRANSPARENT);
  ::TextOut(hdc, 10, 0, msg, strlen (msg));
  ::SetBkMode (hdc, old_bk_mode);
}

void
StatusWnd::Printf (char* fmt, ...)
{
  va_list ap;
  va_start (ap, fmt);
  wvsprintf (msg, fmt, ap);
  va_end (ap);
  HDC hdc = GetDC ();
  Display (hdc);
  ReleaseDC (hdc);
}

void
StatusWnd::StrIdPrintf (UINT fmt_str_id, ...)
{
  RStr rstr (fmt_str_id);
  va_list ap;
  va_start (ap, fmt_str_id);
  wvsprintf (msg, rstr, ap);
  va_end (ap);
  HDC hdc = GetDC ();
  Display (hdc);
  ReleaseDC (hdc);
}

void
StatusWnd::ClearMsg ()
{
  msg[0] = '\0';
  HDC hdc = GetDC ();
  Display (hdc);
  ReleaseDC (hdc);
}
