// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// termwnd.h:
//
// class TermWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/termwnd.h,v 1.2 1994/05/05 16:19:41 kudou Exp $

#ifndef _leaf_termwnd_h
#define _leaf_termwnd_h

#include "comm.h"

class TermWnd
: public TextWnd
{
  Comm comm;
  bool local_echo_p;
  Wnd* parent;
  
 public:
  TermWnd (Wnd* parent);
  ~TermWnd ();
  void OpenComm ();
  void CloseComm ();
  Comm& GetComm () { return comm; }

 protected:
  virtual DWORD GetCreateWindowStyle ();
  virtual LPSTR GetCaptionStr ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual HWND GetParent ();
  void WmCommNotify (WPARAM wparam, LPARAM lparam);
  void WmChar (WPARAM wparam, LPARAM lparam);
 public:
  virtual void SetFocus ();
};

#endif /* _leaf_termwnd_h */
