// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// wnd.cpp:
//
// class Wnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/wnd.cpp,v 1.12 1994/05/05 16:21:34 kudou Exp $

#include "lw.h"
#include <string.h>
#include <assert.h>
#include <stdarg.h>

static char* win_class_name = "WndV20";
bool Wnd::register_flag = False;

bool
Wnd::RegisteredP ()
{
  return MSWin::GetPrevInstance () || RegisterFlag ();
}

bool
Wnd::RegisterFlag ()
{
  return register_flag;
}

void 
Wnd::RegisterClass ()
{
  if (RegisteredP ())
  {
    return;
  }
  WNDCLASS wcClass;
  wcClass.lpszClassName = win_class_name;
  wcClass.hInstance     = MSWin::GetInstance ();
  wcClass.lpfnWndProc   = ::WindowProc;
  wcClass.hCursor       = LoadCursor (NULL, IDC_ARROW);
  wcClass.hIcon         = LoadIcon (MSWin::GetInstance (), IDI_APPLICATION);
  wcClass.lpszMenuName  = (LPSTR) NULL;
  wcClass.hbrBackground = GetStockObject (WHITE_BRUSH);
  wcClass.style         = CS_HREDRAW | CS_VREDRAW;
  wcClass.cbClsExtra    = 0;
  wcClass.cbWndExtra    = sizeof (Wnd*);
  ::RegisterClass (&wcClass);
  register_flag = True;
}

Wnd::Wnd ()
{
}

Wnd::~Wnd ()
{
  Accel::RemoveEntry (this);
}

void 
Wnd::OpenWindow ()
{
  RegisterClass ();
  SetHandle (CreateWindow (win_class_name,	// window class name
			   win_class_name,	// window title.
			   (WS_OVERLAPPEDWINDOW |
			    WS_MAXIMIZEBOX |
			    WS_MINIMIZEBOX),	// type of window
			   CW_USEDEFAULT,	// x - default location.
			   0,
			   CW_USEDEFAULT,	// y - default location.
			   0,
			   NULL,		// no parent window
			   NULL,		// use the class menu
			   MSWin::GetInstance (),// who created this window
			   (LPSTR) this));	// params to pass on
  Update ();
}

void
Wnd::Update ()
{
  ShowWindow (MSWin::GetCmdShow ());	// display this window
  UpdateWindow ();			// paint the clinent area.
}

long 
Wnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_DESTROY:
    PostQuitMessage (0);
    break;
    
   case WM_SETFOCUS:
    SetFocus ();
    break;
    
   case WM_SIZE:
    {
      RECT rec;
      ::GetClientRect (GetHandle (), &rec);
      Resize (rec.left, rec.top, rec.right, rec.bottom);
    }
    break;
    
   default:
    return DefWindowProc (handle, msg, wparam, lparam);
  }
  return 0L;
}

CFUNC long CALLBACK 
WindowProc (HWND handle, UINT msg, WPARAM wparam, LPARAM lparam)
{
#if defined (__SMALL__) || defined (__MEDIUM__)
  Wnd* wd = (Wnd*)GetWindowWord (handle, 0);
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
  Wnd* wd = (Wnd*)GetWindowLong (handle, 0);
#endif
  if (wd == 0)
  {
    if (msg == WM_CREATE)
    {
      LPCREATESTRUCT lpcs;
      lpcs = (LPCREATESTRUCT)lparam;
      wd = (Wnd*)lpcs->lpCreateParams;
#if defined (__SMALL__) || defined (__MEDIUM__)
      SetWindowWord (handle, 0, (WORD)wd);	// regist this to window
#endif
#if defined (__LARGE__) || defined (__COMPACT__)
      SetWindowLong (handle, 0, (LONG)wd);	// regist this to window
#endif
    }
    else
    {
      return ::DefWindowProc (handle, msg, wparam, lparam);
    }
  }
  return wd->WindowProc (msg, wparam, lparam);
}

HDC 
Wnd::GetDC ()
{
  return ::GetDC (GetHandle ());
}

void 
Wnd::ReleaseDC (HDC dc)
{
  ::ReleaseDC (GetHandle (), dc);
}

void
Wnd::GetWindowRect (RECT FAR* rec)
{
  ::GetClientRect (GetHandle (), rec);
}

int
Wnd::GetWindowXSize ()
{
  RECT rec;
  GetWindowRect (&rec);
  return rec.right - rec.left + 1;
}

int
Wnd::GetWindowYSize ()
{
  RECT rec;
  GetWindowRect (&rec);
  return rec.bottom - rec.top + 1;
}

void
Wnd::SetFocus ()
{
  ;
}

void
Wnd::Resize (WORD /*left*/, WORD /*top*/, WORD /*right*/, WORD /*bottom*/)
{
  ;
}

void
Wnd::MoveWindow (WORD left, WORD top, WORD right, WORD bottom)
{
  ::MoveWindow (GetHandle (), left, top, right - left, bottom - top, TRUE);
}

void
Wnd::SetWindowText (char* caption)
{
  ::SetWindowText (GetHandle (), caption);
}

int
Wnd::MessageBox (UINT text_str_id, UINT title_str_id, UINT style)
{
  RStr text (text_str_id);
  RStr title (title_str_id);
  return MessageBox (text, title, style);
}

int
Wnd::MessageBox (LPCSTR text_str, UINT title_str_id, UINT style)
{
  RStr title (title_str_id);
  return MessageBox (text_str, title, style);
}

int
Wnd::MessageBoxPrintf (UINT text_fmtstr_id,
		       UINT title_str_id, UINT style, ...)
{
  RStr format (text_fmtstr_id);
  RStr title (title_str_id);
  char buffer[256];
  assert (strlen (format) < 256);
  va_list ap;
  va_start (ap, style);
  wvsprintf (buffer, format, ap);
  va_end (ap);
  return MessageBox (buffer, title, style);
}

int
Wnd::MessageBoxPrintf (UINT text_fmtstr_id,
		       LPCSTR title, UINT style, ...)
{
  RStr format (text_fmtstr_id);
  char buffer[256];
  assert (strlen (format) < 256);
  va_list ap;
  va_start (ap, style);
  wvsprintf (buffer, format, ap);
  va_end (ap);
  return MessageBox (buffer, title, style);
}

int
Wnd::MessageBoxPrintf (LPCSTR format,
		       UINT title_str_id, UINT style, ...)
{
  RStr title (title_str_id);
  char buffer[256];
  assert (strlen (format) < 256);
  va_list ap;
  va_start (ap, style);
  wvsprintf (buffer, format, ap);
  va_end (ap);
  return MessageBox (buffer, title, style);
}

int
Wnd::MessageBoxPrintf (LPCSTR format,
		       LPCSTR title, UINT style, ...)
{
  char buffer[256];
  assert (strlen (format) < 256);
  va_list ap;
  va_start (ap, style);
  wvsprintf (buffer, format, ap);
  va_end (ap);
  return MessageBox (buffer, title, style);
}
