// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// atom.cc:
//
// class Atom
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/atom.cc,v 1.4 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"

Atom::Atom ()
{
  name = 0;
  bind = 0;
}

Atom::Atom (char* s, size_t n)
{
  name = new char[n + 1];
  bind = 0;
  char* p = name;
  for (size_t i = 0; i < n; i++)
  {
    *p++ = *s++;
  }
  *p = '\0';
}

Atom::~Atom ()
{
  delete name;
}

size_t
Atom::SizeOf ()
{
  return sizeof (Atom);
}

WoolType
Atom::TypeOf ()
{
  return WT_Atom;
}

void
Atom::Print (Wool& wool)
{
  wool.Printf ("%s", name);
}

bool
Atom::Match (char* s, size_t n)
{
  char* p = name;
  for (size_t i = 0; i < n; i++)
  {
    if (*p++ != *s++)
    {
       return False;
    }
  }
  return (*p == '\0') ? True : False;
}

void
Atom::SetGCMark ()
{
  Object::SetGCMark ();
  if (bind && !bind->GCMarkP ()) 
  {
    bind->SetGCMark ();
  }
}
