// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// file.cc:
//
// class File
// class IFile
// class OFile
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/file.cc,v 1.5 1994/05/02 16:05:02 kudou Exp $

#include "file.h"
extern "C"
{
#include <errno.h>  
#include <stdarg.h>
}

// class File
File::File (FILE* fp)
{
  File::fp = fp;
  error_p = False;
  errno = 0;
  close_p = False;
}

File::File (char* file_name, char* mode)
{
  SetCloseP (True);
  SetFP (fopen (file_name, mode));
  if (!GetFP ())
  {
    SetErrorP (True);
    SetErrno ();
  }
}

File::~File ()
{
  Close ();
}

void
File::Close ()
{
  if (fp != 0)
  {
    if (CloseP ())
    {
      fclose (fp);
    }
    else
    {
      fflush (fp);
    }
  }
  fp = 0;
}

void
File::SetErrno ()
{
  errno = ::errno;
}

// class OFile

OFile::OFile (char* file_name)
: file (file_name, "w")
{
}

OFile::OFile (FILE* fp)
: file (fp)
{
}

OFile::~OFile ()
{
}

void
OFile::Printf (char* f, ...)
{
  va_list a;
  va_start (a, f);
  if (!file.ErrorP ())
  {
    vfprintf (file.GetFP (), f, a);
    fflush (file.GetFP ());
  }
  va_end (a);
}

void
OFile::Vprintf (char* f, va_list arg)
{
  if (!file.ErrorP ())
  {
    vfprintf (file.GetFP (), f, arg);
    fflush (file.GetFP ());
  }
}

bool
OFile::ErrorP ()
{
  return file.ErrorP ();
}

// class IFile

IFile::IFile (char* file_name)
: file (file_name, "r")
{
}

IFile::IFile (FILE* fp)
: file (fp)
{
}

IFile::~IFile ()
{
}

char*
IFile::Gets (char* read_buf, size_t read_buf_size)
{
  char* ret = 0;
  if (!file.ErrorP ())
  {
    ret = fgets (read_buf, read_buf_size, file.GetFP ());
  }
  return ret;
}

bool
IFile::ErrorP ()
{
  return file.ErrorP ();
}

