// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// file.h:
//
// class File
// class OFile
// class IFile
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/file.h,v 1.3 1994/05/02 15:56:07 kudou Exp $

#ifndef _file_h
#define _file_h

#include "flow.h"
extern "C"
{
#include <stdio.h>
}

class File
{
  FILE* fp;
  bool error_p;
  int errno;
  bool close_p;
  
 public:
  File (FILE* fp);
  File (char* file_name, char* mode);
  ~File ();
  FILE* GetFP () { return fp; }
  bool ErrorP () { return error_p; }
  int Errno () { return errno; }
  bool CloseP () { return close_p; }
  void SetFP (FILE* fp) { File::fp = fp; }
  void SetErrorP (bool p) { error_p = p; }
  void SetErrno ();
  void SetCloseP (bool p) { close_p = p; }
  void Close ();
};

class OFile
: public OFlow
{
  File file;
  
 public:
  OFile (char* file_name);
  OFile (FILE* fp);
  virtual ~OFile ();
  virtual void Printf (char* f, ...);
  virtual void Vprintf (char* f, va_list arg);
  virtual bool ErrorP ();
};

class IFile
: public IFlow
{
  File file;
  
 public:
  IFile (char* file_name);
  IFile (FILE* fp);
  virtual ~IFile ();
  virtual char* Gets (char* read_buf, size_t read_buf_size);
  virtual bool ErrorP ();
};

#endif /* _file_h */
