// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// flow.h:
//
// class Flow
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/flow.h,v 1.5 1994/05/02 15:56:07 kudou Exp $

#ifndef _flow_h
#define _flow_h

#include "typedef.h"
#include "conf.h"

extern "C"
{
#include <stddef.h>	/* for size_t */
#include <stdarg.h> 
}

class Flow
{
 public:
  virtual ~Flow ();
  virtual bool ErrorP () = 0;
};

class OFlow
: public Flow
{
 public:
  virtual ~OFlow ();
  virtual void Printf (char* f, ...) = 0;
  virtual void Vprintf (char* f, va_list arg) = 0;
  virtual bool ErrorP () = 0;
};

class IFlow
: public Flow
{
 public:
  virtual ~IFlow ();
  virtual char* Gets (char* read_buf, size_t read_buf_size) = 0;
  virtual bool ErrorP () = 0;
};

#endif /* _flow_h */
