// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// free.cc:
//
// class Free
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/free.cc,v 1.7 1994/05/02 16:05:02 kudou Exp $

#include "wool.h"
extern "C"
{
#include <assert.h>
}

void*
operator new (size_t /*size*/, Free* p)
{
  return p;
}

Free::Free (size_t size, Free* next)
{
#ifndef NDEBUG
  if (size < sizeof (Free))
  {
    assert (False);
  }
  // this  size ̓ACĂ邱ƂO
  if (size != MemAlineSize (size))
  {
    assert (False);
  }
  if (this != MemAline (this))
  {
    assert (False);
  }
#endif
  Free::size = size;
  Free::next = next;
  
  // clear memory
  size_t en = size - sizeof (Free);
  char* p = (char*)((void*)this) + sizeof (Free);
  for (size_t n = 0; n < en; n++)
  {
    *p++ = 0;
  }
}

Free::~Free ()
{
}

size_t
Free::SizeOf ()
{
  return size;
}

WoolType
Free::TypeOf ()
{
  return WT_Free;
}

void
Free::Print (Wool& wool)
{
  wool.Printf ("<Free size:%d>", size);
}

void*
Free::GetNextPtr ()
{
  return MemAline ((char*)this + size);
}

void*
Free::GetMemory (size_t s)
{
  // this  size łɃACgĂ̂OƂȂ
  if (size - MemAlineSize (sizeof (Free)) > MemAlineSize (s))
  {
    // ̂Ă郁ォ炿ĕĂ
    size -= MemAlineSize (s);
    return (void*)((char*)this + size);
  }
  else if (size >= s)
  {
    // ̃IuWFNg͂̌シE
    return (void*)this;
  }
  else
  {
    // ̃IuWFNg̓Ȃ
    return 0;
  }
}
