// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// namespac.cc:
//
// class NameSpace
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/namespac.cc,v 1.7 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"
extern "C"
{
#include <string.h>
}

NameSpace::NameSpace (Wool* wool)
{
  NameSpace::wool = wool;
  for (unsigned int i = 0; i < hash_table_size; i++)
  {
    hash_table[i] = 0;
  }
}

unsigned int
NameSpace::Hash (char* p, size_t n)
{
  unsigned int hash = 5 * n;
  for (size_t i = 0; i < n; i++)
  {
    hash = (hash << 2) ^ *p++;
  }
  return hash % hash_table_size;
}

Atom*
NameSpace::GetAtom (char* name, size_t n)
{
  // search
  unsigned int index = Hash (name, n);
  Atom* top = hash_table[index];
  for (Atom* a = top; a != 0; a = a->GetNext ())
  {
    if (a->Match (name, n))
    {
      return a;
    }
  }
  // create
  a = new (wool) Atom (name, n);
  a->SetNext (top);
  hash_table[index] = a;
  return a;
}

Atom*
NameSpace::GetAtom (char* name)
{
  return GetAtom (name, strlen (name));
}

void
NameSpace::SetGCMark ()
{
  for (size_t i = 0; i < hash_table_size; i++)
  {
    for (Atom* a = hash_table[i]; a != 0; a = a->GetNext ())
    {
      a->SetGCMark ();
      Object* o = a->GetBind ();
      if (o)
      {
	o->SetGCMark ();
      }
    }
  }
}
