;;; $Header: /d/1/proj/egypt/0/wool/RCS/sample.w,v 1.3 1994/02/13 11:28:02 kudou Exp $
;;; sample wool program

(object-number)

;; sample of lambda
((lambda (x y) (cons (car x) y)) '(a b c) "xxx")
;=>(a."xxx")

;; sample of label
((label kansu (lambda (x) (cons (car x) (quote a)))) '("XX" b c))
;=>("XX".a)

;; sample of define
(define '((zoo (lambda (x) (car x)))))
;=>(zoo)
(zoo '(a b c))
;=>a

;; sample of defun. definition of EXPR
(defun foo (x) (car x))
;=>foo
(foo '(a b c))
;=>a

;; sample of defun.  definition of FEXPR
(defun bar fexpr (x) (car x))
;=>bar
(bar (a b c))
;=>a

;; sample of macro.
;; see LISP by Patrick Henry Winston Berthold, Klaus Paul Horm
(defun if3 macro (x)
  (print
   (subst (cadr x) '1st
	  (subst (caddr x) '2nd
		 (subst (cadddr x) '3rd
			'(cond (1st 2nd) (t 3rd)))))))
;=>if3
(if3 t "aaa" "bbb")
;=>"aaa"
(if3 nil "aaa" "bbb")
;=>"bbb"

;; macro version if
(defun iff macro (x)
  (subst (cadr x) '1st
	 (subst (caddr x) '2nd
		(subst (cond ((equal (length x) 4)
			      (cadddr x))
			     (t nil))
		       '3rd
		       '(cond (1st 2nd) (t 3rd))))))

(iff t "aaa" "bbb")
;=>"aaa"
(iff nil "aaa" "bbb")
;=>"bbb"
(iff t "aaa")
;=>"aaa"
(iff nil "aaa")
;=>nil

;; sample of let
(let ((x 1) (y 2))
  (print x)
  (print y))
;=>1
;=>2
;=>2

;; sample of if
(if t "aaa")
;=>"aaa"
(if nil "aaa")
;=>nil
(if nil "aaa" "bbb")
;=>"bbb"

;; sample while
(let ((x 0))
  (while (lessp x 10)
    (print x)
    (setq x (add1 x))))
;=>0
;=>1
;=>2
;=>3
;=>4
;=>5
;=>6
;=>7
;=>8
;=>9
;=>nil

;; fibonacii function
(defun fibonacci (n)
  (cond ((zerop n) 1)
	((equal n 1) 1)
	(t (plus (fibonacci (difference n 1))
		 (fibonacci (difference n 2))))))

(let ((x 0))
  (while (lessp x 10)
    (print x)
    (print (fibonacci x))
    (setq x (add1 x))))

(object-number)

(end)
;=>"nil"
