// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// misc.cc:
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/misc.cc,v 1.2 1994/05/02 14:46:49 kudou Exp $

#include "config.h"

#ifdef DONT_HAVE_MEMMOVE
void
memmove(void* dest, void* src, size_t n)
{
  char* dest_p = (char*)dest;
  char* src_p = (char*)src;
  if (dest_p < src_p)
  {
    char* to = (char*)(dest_p + n);
    while (dest_p < to)
    {
      *dest_p ++ = *src_p ++; 
    }
  }
  else if (dest_p > src_p)
  {
    char* to = (char*)(dest_p);
    dest_p += n;
    src_p += n;
    while (dest_p > to)
    {
      *dest_p -- = *src_p --;
    }
  }
}
#endif
