// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// edit.h:
//
// EditWnd sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/sample/edit/RCS/edit.h,v 1.13 1994/05/09 16:31:15 kudou Exp $

#ifndef _edit_h
#define _edit_h

class Edit
: public BaseWnd
{
  EditWnd* edit_wnd;
  StatusWnd* status_wnd;
  enum { border_size = 6 };

 protected:
  // replacement
  virtual LPSTR GetCaptionStr ();
  virtual void OpenChildWindow ();
  virtual void SetFocus ();
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual LPSTR GetMenuName ();
  virtual void Update ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void Display (HDC hdc);
  virtual uword Menu (WPARAM wparam, LPARAM lparam);
  void MenuSelect (WPARAM wparam);

  EditWnd* GetEditWnd () { return edit_wnd; }
  StatusWnd* GetStatusWnd () { return status_wnd; }

 public:
  Edit ();
  ~Edit ();
};

// menu ID
#define MENU_ID_FILE_OPEN	101
#define MENU_ID_FILE_SAVE	102
#define MENU_ID_FILE_SAVE_AS	103
#define MENU_ID_FILE_EXIT	106
#define MENU_ID_EDIT_UNDO	201
#define MENU_ID_EDIT_CUT	202
#define MENU_ID_EDIT_COPY	203
#define MENU_ID_EDIT_PASTE	204
#define MENU_ID_EDIT_DELETE	205
#define MENU_ID_HELP_ABOUT	504
#define MENU_ID_TEST		999

// menu help string ID
#define MHELP_OFFSET            1000
#define MHELP_ID_FILE_OPEN	MENU_ID_FILE_OPEN + MHELP_OFFSET
#define MHELP_ID_FILE_SAVE	MENU_ID_FILE_SAVE + MHELP_OFFSET
#define MHELP_ID_FILE_SAVE_AS	MENU_ID_FILE_SAVE_AS + MHELP_OFFSET
#define MHELP_ID_FILE_EXIT	MENU_ID_FILE_EXIT + MHELP_OFFSET
#define MHELP_ID_EDIT_UNDO	MENU_ID_EDIT_UNDO + MHELP_OFFSET
#define MHELP_ID_EDIT_CUT	MENU_ID_EDIT_CUT + MHELP_OFFSET
#define MHELP_ID_EDIT_COPY	MENU_ID_EDIT_COPY + MHELP_OFFSET
#define MHELP_ID_EDIT_PASTE	MENU_ID_EDIT_PASTE + MHELP_OFFSET
#define MHELP_ID_EDIT_DELETE	MENU_ID_EDIT_DELETE + MHELP_OFFSET
#define MHELP_ID_HELP_ABOUT	MENU_ID_HELP_ABOUT + MHELP_OFFSET
#define MHELP_ID_TEST		MENU_ID_TEST + MHELP_OFFSET

#endif /* _edit_h */
