// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// accel.cpp:
//
// class Accel
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/accel.cpp,v 1.3 1994/03/25 08:24:54 kudou Exp $

#include "lw.h"

static Accel* accel_entry_list = 0;

Accel::Accel (Wnd* wnd, HACCEL accel)
{
  Accel::wnd = wnd;
  Accel::accel = accel;
  Add ();
}

Accel::~Accel ()
{
  Remove ();
}

void
Accel::Add ()
{
  next = accel_entry_list;
  accel_entry_list = this;
}

void
Accel::Remove ()
{
  Accel* prev = 0;
  for (Accel* e = accel_entry_list; e != 0; e = e->next)
  {
    if (e == this)
    {
      if (prev)
      {
	prev->next = next;
      }
      else
      {
	accel_entry_list = next;
      }
      break;
    }	
    prev = e;
  }
}

void
Accel::RemoveEntry (Wnd* wnd)
{
  for (Accel* e = accel_entry_list; e != 0; e = e->next)
  {
    if (e->GetWnd () == wnd)
    {
      delete e;
      break;
    }
  }
}

bool
Accel::TranslateAccel (MSG* msg)
{
  for (Accel* e = accel_entry_list; e != 0; e = e->next)
  {
    if (e->accel &&
	(e->wnd)->GetHandle () &&
	::TranslateAccelerator ((e->wnd)->GetHandle (), e->accel, msg))
    {
      return True;
    }
  }
  return False;
}

Accel*
Accel::LoadAccelerators (Wnd* wnd, LPCSTR name)
{
  HACCEL accel = MSWin::LoadAccelerators (name);
  return new Accel (wnd, accel);
}
