// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// dlg.cpp:
//
// class Dlg
// class ModalDlg
// class ModelessDlg
// -------------------------------------------------------------------- //
// $Header: /a/googol/d/1/proj/egypt/0/lw/src/RCS/dlg.cpp,v 1.6 1994/05/08 16:43:41 kudou Exp $

#include "lw.h"
#include <assert.h>

// -------------------------------------------------------------------- //
// class Dlg
// -------------------------------------------------------------------- //
void
Dlg::Add (Dlg*& dlglist)
{
  next = dlglist;
  dlglist = this;
}

void
Dlg::Remove (Dlg*& dlglist)
{
  Dlg* prev = 0;
  for (Dlg* d = dlglist; d != 0; d = d->next)
  {
    if (d == this)
    {
      if (prev)
      {
	prev->next = next;
      }
      else
      {
	dlglist = next;
      }
      break;
    }	
    prev = d;
  }
}

Dlg* 
Dlg::FindThis (Dlg*& dlglist, HWND handle)
{
  for (Dlg* d = dlglist; d != 0; d = d->next)
  {
    if (d->GetHandle () == handle)
    {
      return d;
    }
  }
  return 0;
}

Dlg::Dlg (char* dlg_name, VWin* parent)
{
  Dlg::dlg_name = dlg_name;
  Dlg::parent = parent;
  next = 0;
}

Dlg::~Dlg ()
{
}

void
Dlg::EndDialog (bool end)
{
  ::EndDialog(handle, end);
}

HWND 
Dlg::GetDlgItem (int a)
{
  return ::GetDlgItem (handle, a);
}

void 
Dlg::SetDlgItemInt (int a, WORD b, BOOL c)
{
  ::SetDlgItemInt (handle, a, b, c);
}

WORD 
Dlg::GetDlgItemInt (int a, BOOL FAR* b, BOOL c)
{
  return ::GetDlgItemInt (handle, a, b, c);
}

void 
Dlg::SetDlgItemText (int a, LPSTR b)
{
  ::SetDlgItemText (handle, a, (LPSTR)b);
}

int 
Dlg::GetDlgItemText (int a, LPSTR b, int c)
{
  return ::GetDlgItemText (handle, a, (LPSTR)b, c);
}

void 
Dlg::CheckDlgButton (int a, WORD b)
{
  ::CheckDlgButton (handle, a, b);
}

void 
Dlg::CheckRadioButton (int a, int b, int c)
{
  ::CheckRadioButton (handle, a, b, c);
}

WORD 
Dlg::DlgButtonCheckedP (int a)
{
  return ::IsDlgButtonChecked (handle, a);
}

LONG 
Dlg::SendDlgItemMessage (int a, WORD b, WORD c, LONG d)
{
  return ::SendDlgItemMessage (handle, a, b, c, d);
}

void
Dlg::SetFocus (int id)
{
  ::SetFocus (GetDlgItem (id));
}

bool
Dlg::EnableWindow (int id, bool a)
{
  return (bool)::EnableWindow (GetDlgItem (id), (BOOL)a);
}

bool
Dlg::WindowEnabledP (int id)
{
  return (bool)::IsWindowEnabled (GetDlgItem (id));
}

BOOL
Dlg::WmInitDialog ()
{
  RECT rec;
  ::GetWindowRect (::GetDesktopWindow (), &rec);
  int dx = rec.right - rec.left;
  int dy = rec.bottom - rec.top;
  ::GetWindowRect (GetHandle (), &rec);
  int width = rec.right - rec.left;
  int height = rec.bottom - rec.top;
  ::MoveWindow (GetHandle (), 
		(dx - width) / 2,
		(dy - height) / 2,
		width, height, True);
  return 0;
}

BOOL
Dlg::WmCommand (WPARAM /*wparam*/)
{
  return 0;
}

BOOL
Dlg::WmClose ()
{
  return 0;
}

// -------------------------------------------------------------------- //
// class ModalDlg
// -------------------------------------------------------------------- //
static Dlg* modal_dlg_list = 0;

ModalDlg::ModalDlg (char* dlg_name, VWin* parent)
: Dlg (dlg_name, parent)
{
  Add (modal_dlg_list);
}

ModalDlg::~ModalDlg ()
{
  Remove (modal_dlg_list);
}

bool 
ModalDlg::Go ()
{
  FARPROC func = ::MakeProcInstance ((FARPROC)ModalDlgWindowProc,
				     MSWin::GetInstance());
  bool ret = ::DialogBoxParam (MSWin::GetInstance(),
			       dlg_name,
			       GetParentHandle (),
			       func,
			       (LONG)(this));
  return ret;
}  

long 
ModalDlg::DefDlgProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  assert (handle != 0);
  return ::DefDlgProc (handle, msg, wparam, lparam);
}

BOOL
ModalDlg::WindowProc (UINT msg, WPARAM wparam, LPARAM /*lparam*/)
{
  switch (msg)
  {
   case WM_INITDIALOG:
    return WmInitDialog ();

   case WM_COMMAND:
    return WmCommand (wparam);

   case WM_CLOSE:
    return WmClose ();
  }
  return 0;
}

BOOL
ModalDlg::WmCommand (WPARAM wparam)
{
  switch (wparam)
  {
   case IDOK:
    EndDialog (True);
    return 1;
    
   case IDCANCEL:
    EndDialog (False);
    return 1;
  }
  return 0;
}

BOOL
ModalDlg::WmClose ()
{
  EndDialog (False);
  return 1;
}

CFUNC BOOL CALLBACK
ModalDlgWindowProc (HWND handle, UINT msg, WPARAM wparam, LPARAM lparam)
{
  if (msg == WM_INITDIALOG)
  {
    Dlg* dlg = (Dlg*)((void*)lparam);
    assert (dlg != 0);
    dlg->SetHandle (handle);
    dlg->WindowProc (WM_INITDIALOG, wparam, lparam);
    return 1;
  }
  else
  {
    Dlg* dlg = Dlg::FindThis (modal_dlg_list, handle);
    if (dlg)
    {
      return dlg->WindowProc (msg, wparam, lparam);
    }
    else
    {
      return 0;
    }
  }
}

// -------------------------------------------------------------------- //
// class ModelessDlg
// -------------------------------------------------------------------- //
static Dlg* modeless_dlg_list = 0;

ModelessDlg::ModelessDlg (char* dlg_name, VWin* parent)
: Dlg (dlg_name, parent)
{
  Add (modeless_dlg_list);
}

ModelessDlg::~ModelessDlg ()
{
  Remove (modeless_dlg_list);
}

bool
ModelessDlg::Go ()
{
  FARPROC func = ::MakeProcInstance ((FARPROC)ModelessDlgWindowProc,
				     MSWin::GetInstance());
  ::CreateDialogParam (MSWin::GetInstance(),
		       GetDlgName (),
		       GetParentHandle (),
		       func,
		       (LONG)(this));
  return 0;
}

BOOL
ModelessDlg::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_INITDIALOG:
    return WmInitDialog ();

   case WM_COMMAND:
    return WmCommand (wparam);

   case WM_CLOSE:
    return WmClose ();
  }
  return 0;
}

bool
ModelessDlg::CheckMessage (MSG* msg)
{
  for (Dlg* dlg = modeless_dlg_list;
       dlg != 0;
       dlg = dlg->GetNext ())
  {
    if ((dlg->GetHandle ()) &&
	(::IsDialogMessage (dlg->GetHandle (), msg)))
    {
      return True;
    }
  }
  return False;
}

CFUNC BOOL CALLBACK
ModelessDlgWindowProc (HWND handle, UINT msg, WPARAM wparam, LPARAM lparam)
{
  if (msg == WM_INITDIALOG)
  {
    Dlg* dlg = (Dlg*)((void*)lparam);
    assert (dlg != 0);
    dlg->SetHandle (handle);
    dlg->WindowProc (WM_INITDIALOG, wparam, lparam);
    return 1;
  }
  else
  {
    Dlg* dlg = Dlg::FindThis (modeless_dlg_list, handle);
    if (dlg)
    {
      return dlg->WindowProc (msg, wparam, lparam);
    }
    else
    {
      return 0;
    }
  }
}
