// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mdi.h:
//
// class MdiFrameWnd
// class MdiClientWnd
// class MdiChildWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/mdi.h,v 1.3 1994/04/22 09:17:45 kudou Exp $

#ifndef _lw_mdi_h
#define _lw_mdi_h

class MdiClientWnd;

class MdiFrameWnd
: public BaseWnd
{
  static bool register_flag;
  MdiClientWnd* mdi_client_wnd;

 public:
  MdiFrameWnd ();
  ~MdiFrameWnd ();

 protected:
  virtual bool RegisterFlag ();
  virtual void SetRegisterFlag ();
  virtual LPSTR GetClassName ();
  virtual LPSTR GetCaptionStr ();
  virtual DWORD GetCreateWindowStyle ();
  virtual void OpenChildWindow ();
  virtual long WindowProc (UINT msg, WPARAM wParam, LPARAM lParam);
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);

 public:  
  HWND GetMdiClientHandle ();
  MdiClientWnd* GetMdiClientWnd () { return mdi_client_wnd; }
  virtual HMENU GetWindowMenu ();
};

class MdiClientWnd
: public BaseWnd
{
  MdiFrameWnd* parent;
  WORD first_child_id;
  MdiClientWnd* next;

 public:
  MdiClientWnd (MdiFrameWnd* parent);
  ~MdiClientWnd ();
  virtual void OpenWindow ();
  virtual HWND GetParent ();

  void SetFirstMdiChildID (WORD f) { first_child_id = f; }
  
  static bool TranslateAccel (MSG* msg);
 protected:
  DWORD GetCreateWindowStyle ();
  void Add ();
  void Remove ();
};

class MdiChildWnd
: public BaseWnd
{
  static bool register_flag;
  MdiFrameWnd* mdi_frame_wnd;
  
 public:
  MdiChildWnd (MdiFrameWnd* mdi_frame_wnd);
  ~MdiChildWnd ();
  virtual void OpenWindow ();
  MdiFrameWnd* GetMdiFrameWnd () { return mdi_frame_wnd; }
  MdiClientWnd* GetMdiClientWnd ();

 protected:
  virtual bool RegisterFlag ();
  virtual void SetRegisterFlag ();
  virtual void Update ();
  virtual HWND GetParent ();
  virtual LPSTR GetClassName ();
  virtual WNDPROC GetWindowProc ();
  virtual LPSTR GetCaptionStr ();
  virtual DWORD GetCreateWindowStyle ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
}; 

CFUNC long CALLBACK MdiChildWindowProc (HWND, UINT, WPARAM, LPARAM);

#endif /* _lw_mdi_h */
