// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// termwnd.cpp:
//
// class TermWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/termwnd.cpp,v 1.3 1994/05/05 16:59:09 kudou Exp $

#include "lw.h"

#define CR 0x0d
#define LF 0x0a
#define BS 0x08
#define DEL 0x7f

TermWnd::TermWnd (Wnd* parent)
{
  local_echo_p = False;
  TermWnd::parent = parent;
}

TermWnd::~TermWnd ()
{
  comm.Close ();
}

void
TermWnd::OpenComm ()
{
  comm.Open (this);
}

void
TermWnd::CloseComm ()
{
  comm.Close ();
}

LPSTR
TermWnd::GetCaptionStr ()
{
  return "TermWnd";
}

DWORD
TermWnd::GetCreateWindowStyle ()
{
  return WS_HSCROLL | WS_VSCROLL | WS_CHILD;
}

HWND
TermWnd::GetParent ()
{
  return parent->GetHandle ();
}

void
TermWnd::SetFocus ()
{
  ::SetFocus (GetHandle ());
  TextWnd::SetFocus ();
}

void
TermWnd::WmChar (WPARAM wparam, LPARAM lparam)
{
  char c = (char)wparam;
  if (!comm.Write (&c, 1))
  {
    MessageBoxPrintf ("Comm Port Write Error (%04x)", "TTY", MB_OK,
		      comm.GetCommError ());
  }
  if (local_echo_p)
  {
    PutChar (c);
  }
}

void
TermWnd::WmCommNotify (WPARAM wparam, LPARAM lparam)
{
  if (wparam != comm.GetCommId ())
  {
    return;
  }
  MSG msg;
  static char read_buf[Comm::MaxBlockSize + 1];
  if (comm.UseCnReceiveP ())
  {
    // CN_RECEIVE message
    if (!(CN_RECEIVE & LOWORD (lparam)))
    {
      return;
    }
    do
    {
      int read_size = comm.Read (read_buf, Comm::MaxBlockSize);
      if (read_size < 0)
      {
	MessageBoxPrintf ("Comm Port Read Error (%04x)", "TTY", MB_OK,
			  comm.GetCommError ());
      }
      else
      {
	Puts (read_buf, read_size);
      }
    }
    // Windows ̃bZ[WL[Ȃ瑱ēǂݍ
    while ((comm.GetReciveQueCharSize () >= Comm::MaxBlockSize) ||
	   !::PeekMessage (&msg, NULL, 0, 0, PM_NOREMOVE));
    
  }    
  else
  {
    if (!(CN_EVENT & LOWORD (lparam)))
    {
      return;
    }
    ::GetCommEventMask (comm.GetCommId (), EV_RXCHAR);
    int read_size;
    do
    {
      read_size = comm.Read (read_buf, Comm::MaxBlockSize);
      if (read_size < 0)
      {
	MessageBoxPrintf ("Comm Port Read Error (%04x)", "TTY", MB_OK,
			  comm.GetCommError ());
      }
      else
      {
	Puts (read_buf, read_size);
      }
    }
    while (!PeekMessage (&msg, NULL, 0, 0, PM_NOREMOVE) ||
	   (read_size > 0));
  }
}

long
TermWnd::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_CHAR:
    WmChar (wparam, lparam);
    break;
    
   case WM_COMMNOTIFY:
    WmCommNotify (wparam, lparam);
    break;
    
   default:
    return TextWnd::WindowProc (msg, wparam, lparam);
  }
  return 0L;
}
