// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// textwnd.h:
//
// class TextWnd
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/textwnd.h,v 1.3 1994/05/04 17:34:53 kudou Exp $

#ifndef _lw_textwnd_h
#define _lw_textwnd_h

#include <stdarg.h>

#ifndef EOF
#define EOF -1
#endif

enum KanjiStatus
{
  NotKanji,
  KanjiFirstByte,
  KanjiSecondByte,
};

class TextWnd
: public BaseWnd
{
  enum
  {
    default_column_size = 80,
    default_line_size = 25,
    key_buffer_size = 10,
    cook_buffer_size = 256,
  };
  uword font_width;
  uword font_height;
  uword column_size;
  uword line_size;
  
  // caret
  uword caret_column_pos;
  uword caret_line_pos;

  // scroll bar
  word vscroll_pos;
  word hscroll_pos;
  bool set_vscroll_bar_p;
  bool set_hscroll_bar_p;
  
  // virtual screen
  char* buf;
  
  // key buffer
  char key_buffer[key_buffer_size];
  uword key_buffer_ptr;
  
  // tty mode
  bool cooked_p;
  enum TtyMode
  {
    RawMode,
    CookedMode,
  } tty_mode;
  char cook_buffer[cook_buffer_size];
  uword cook_buffer_ptr;
  
  // for kanji
  char kanji_putchar_buf;
  
 public:
  TextWnd (uword column_size = default_column_size,
	   uword line_size = default_line_size);
  ~TextWnd ();

  void Printf (char* fmt, ...);
  void Vprintf (char* fmt, va_list arg);
  char* Gets (char* read_buf, size_t read_buf_size);
  char GetChar ();
  void PutChar (char c);
  void Puts (char* str);
  void Puts (char* str, size_t size);
  void SetRawMode () { tty_mode = RawMode; }
  void SetCookedMode () { tty_mode = CookedMode; cooked_p = False; }
 
 protected:
  void Clear ();
  void SetFont ();
  char* GetLine (uword line) { return &buf[line * column_size]; }
  void ScrollUp ();
  void InvalidateCaretChar ();
  void InvalidateChar (uword column, uword line);
  void TouchCaret ();
  char GetKeyBufferChar ();
  char Cook ();
  char GetCookBufferChar ();
  void CookIn (char c);
  void CookBS ();
  void _PutChar (char c);
  void __PutChar (char c);
  KanjiStatus CheckKanji (char* buf, uword pos);
  void BackwardChar ();
  
  virtual LPSTR GetCaptionStr ();
  virtual DWORD GetCreateWindowStyle ();
  virtual int GetCreateWindowXSize ();
  virtual int GetCreateWindowYSize ();
  virtual void Display (Paint& pnt);
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  void GetMinMaxInfo (MINMAXINFO* info);
  void SetFocus ();
  void KillFocus ();
  void KeyIn (WPARAM wparam, LPARAM lparam);
  void HScroll (WPARAM wparam, LPARAM lparam);
  void VScroll (WPARAM wparam, LPARAM lparam);
};

inline bool 
Kanji1P (char c)
{
  return (((0x81 <= (unsigned char)c) && ((unsigned char)c <= 0x9f)) ||
	  ((0xe0 <= (unsigned char)c) && ((unsigned char)c <= 0xfc)));
}

inline bool
Kanji2P (char c)
{
  return ((0x40 <= (unsigned char)c) && 
	  ((unsigned char)c <= 0xfc) &&
	  ((unsigned char)c != 0x7f));
}

#endif /* _lw_textwnd_h */
