// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// vwin.h:
//
// class VWin
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/src/RCS/vwin.h,v 1.4 1994/04/25 09:36:18 kudou Exp $

#ifndef _lw_vwin_h
#define _lw_vwin_h

class VWin
{
 protected:
  // window handle
  HWND handle;
  
 public:
  VWin () { handle = 0; }
  HWND GetHandle () { return handle; }
  BOOL PostMessage (UINT msg, WPARAM wparam, LPARAM lparam)
  {
    return ::PostMessage (handle, msg, wparam, lparam);
  }
  LRESULT SendMessage (UINT msg, WPARAM wparam, LPARAM lparam)
  {
    return ::SendMessage (handle, msg, wparam, lparam);
  }
  BOOL ShowWindow (int p)
  {
    return ::ShowWindow (handle, p);
  }
  int ExcludeUpdateRgn (HDC dc)
  {
    return ::ExcludeUpdateRgn (dc, handle);
  }
  BOOL LockWindowUpdate ()
  {
    return ::LockWindowUpdate (handle);
  }
  void UpdateWindow ()
  {
    ::UpdateWindow (handle);
  }
  void DestroyWindow ()
  {
    ::DestroyWindow (handle);
  }
  void GetClientRect (RECT* rec)
  {
    ::GetClientRect (handle, rec);
  }
  void GetWindowRect (RECT* rec)
  {
    ::GetWindowRect (handle, rec);
  }
  BOOL GetUpdateRect (RECT* rec, BOOL p)
  {
    return ::GetUpdateRect (handle, rec, p);
  }
  int GetUpdateRgn (HRGN rgn, BOOL p)
  {
    return ::GetUpdateRgn(handle, rgn, p);
  }
  void InvalidateRect (RECT* rec, BOOL p)
  {
    ::InvalidateRect (handle, rec, p);
  }
  void ValidateRect (RECT* rec)
  {
    ::ValidateRect (handle, rec);
  }
  void InvalidateRgn (HRGN rgn, BOOL p)
  {
    ::InvalidateRgn(handle, rgn, p);
  }
  void ValidateRgn (HRGN rgn)
  {
    ::ValidateRgn(handle, rgn);
  }
  BOOL RedrawWindow (RECT* rec, HRGN rgn, UINT flags)
  {
    return ::RedrawWindow (handle, rec, rgn, flags);
  }
 protected:
  void SetHandle (HWND h) { handle = h; }
};

#endif /* _lw_vwin_h */
