// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// fnum.cc:
//
// class FNum
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/fnum.cc,v 1.2 1994/05/02 15:56:07 kudou Exp $

#include "wool.h"

FNum::FNum (double n)
{
  fnum = n;
}

FNum::~FNum ()
{
}

size_t
FNum::SizeOf ()
{
  return sizeof (FNum);
}

WoolType
FNum::TypeOf ()
{
  return WT_FNum;
}

void
FNum::Print (Wool& wool)
{
  wool.Printf ("%f", fnum);
}

bool
FNum::Equal (Object* x)
{
  switch (x->TypeOf ())
  {
   case WT_FNum:
    return (fnum == ((FNum*)x)->fnum);
   case WT_Num:
    return (fnum == ((Num*)x)->GetNum ());
   case WT_Object:
   case WT_Pair:
   case WT_Atom:
   case WT_Str:
   case WT_Free:
   case WT_Func:
    return False;
   default:
    return x->Equal (this);
  }
}
