// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// num.cc:
//
// class Num
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/num.cc,v 1.3 1994/05/07 01:07:20 kudou Exp $

#include "wool.h"

Num::Num (long int n)
{
  num = n;
}

Num::~Num ()
{
}

size_t
Num::SizeOf ()
{
  return sizeof (Num);
}

WoolType
Num::TypeOf ()
{
  return WT_Num;
}

void
Num::Print (Wool& wool)
{
  wool.Printf ("%ld", num);
}

bool
Num::Equal (Object* x)
{
  switch (x->TypeOf ())
  {
   case WT_Num:
    return (num == ((Num*)x)->num);
   case WT_FNum:
    return (num == ((FNum*)x)->GetFNum ());
   case WT_Object:
   case WT_Pair:
   case WT_Atom:
   case WT_Str:
   case WT_Free:
   case WT_Func:
    return False;
   default:
    return x->Equal (this);
  }
}
