// -------------------------------------------------------------------- //
//                        Wool Object Oriented Lisp
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// wingrph.h:
//
// class GrphWnd
// for MS-Windows Graphic Window
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/wool/RCS/wingrph.h,v 1.2 1994/05/06 02:43:41 kudou Exp $

#ifndef _wool_wingrph_h
#define _wool_wingrph_h

#include "lw.h"

#define COLOR_MASK RGB(0xff,0xff,0xff)

class GrphWnd
: public BaseWnd
{
  // only one window
  static GrphWnd* grph_wnd;
  
  // virtual graphic screen
  HBITMAP vscrn;
  int vscrn_width;
  int vscrn_height;
  int vscroll_offset;
  int hscroll_offset;
  
  // for draw
  COLORREF pen_col;
  COLORREF fill_col;
  COLORREF back_col;
  
  enum { scroll_unit = 16 };
  bool set_vscroll_bar_p;
  bool set_hscroll_bar_p;
  
 protected:
  GrphWnd ();
  ~GrphWnd ();
  virtual LPSTR GetCaptionStr ();
  virtual void Display (HDC dc);
  virtual DWORD GetCreateWindowStyle ();
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  void HScroll (WPARAM wparam, LPARAM lparam);
  void VScroll (WPARAM wparam, LPARAM lparam);
  void Invalidate (int x1, int y1, int x2, int y2);
  int GetPenCol () { return pen_col; }
  int GetFillCol () { return fill_col; }
  int GetBackCol () { return back_col; }

 public:
  static void OpenGrphWnd ();
  static void CloseGrphWnd ();
  static GrphWnd* GetGrphWnd () { return grph_wnd; }
  void SetPenCol (int col) { pen_col = col & COLOR_MASK; }
  void SetFillCol (int col) { fill_col = col & COLOR_MASK; }
  void SetBackCol (int col) { back_col = col & COLOR_MASK; }
  int Rgb (int r, int g, int b) { return RGB (r, g, b) & COLOR_MASK; }
  void DrawPixel (int x, int y);
  void DrawText (int x, int y, char* s);
  void DrawTransparentText (int x, int y, char* s);
  void DrawLine (int x1, int y1, int x2, int y2);
  void DrawBox (int x1, int y1, int x2, int y2);
  void DrawBoxFill (int x1, int y1, int x2, int y2);
  void DrawArcFill (int x, int y, int r);
  void Clear ();
  int GetDrawWindowWidth () { return GetWindowXSize (); }
  int GetDrawWindowHeight () { return GetWindowYSize (); }
  int GetDrawScreenWidht () { return vscrn_width; }
  int GetDrawScreenHeight () { return vscrn_height; }
};

#endif /* _wool_wingrph_h */
