# common.mk
# $Header: /d/1/proj/egypt/1/RCS/common.mk,v 1.1 1994/07/23 18:27:38 kudou Exp $

### suffix 
SUFFIXES = .c .cpp .cc .h .obj
.SUFFIXES: $(SUFFIXES)

### misc
AR=
CD=cd
CP=cp
ECHO=echo
INSTALL=cp
MKDIR=mkdir
MV=mv
RC=rc -k
RM=rm -f

### C/C++
# Microsoft Visual C++
ifeq ($(VC), yes)
CC=cl
AR=lib
ifeq ($(DEBUG), yes)
DEBUG_FLAGS=/Zi
else
DEBUG_FLAGS=
endif
CPPFLAG=/Tp
WFLAGS=/GA -DMSW
CFLAGS_=/AL $(DEBUG_FLAGS) $(PRIVATE_CC_FLAGS)
CCOBJ=$(CC) $(CFLAGS_) $(INC) -c 
CCEXE=$(CC) $(CFLAGS_) $(INC) /Fe
CCWOBJ=$(CC) $(WFLAGS) $(CFLAGS_) $(INC) -c 
CCWEXE=$(CC) $(WFLAGS) $(CFLAGS_) $(INC) /Lw commdlg.lib /Fe
OBJ2WEXE=$(CC) $(WFLAGS) $(CFLAGS_) /Lw commdlg.lib /Fe
endif

# Borland C++
ifeq ($(BCC), yes)
CC=bcc
AR=tlib
ifeq ($(DEBUG), yes)
DEBUG_FLAGS=-v
else
DEBUG_FLAGS=
endif
CPPFLAG=-P
WFLAGS=-W -DMSW
CFLAGS_=-ml -k -N $(DEBUG_FLAGS) $(PRIVATE_CC_FLAGS)
CCOBJ=$(CC) $(CFLAGS_) $(INC) -c 
CCEXE=$(CC) $(CFLAGS_) $(INC) -e
CCWOBJ=$(CC) $(WFLAGS) $(CFLAGS_) $(INC) -c 
CCWEXE=$(CC) $(WFLAGS) $(CFLAGS_) $(INC) -e
OBJ2WEXE=$(CC) $(WFLAGS) $(CFLAGS_) -e
endif

# Symantec C++
ifeq ($(SC), yes)
CC=sc
AR=command /c lib
ifeq ($(DEBUG), yes)
DEBUG_FLAGS=-g
else
DEBUG_FLAGS=
endif
CPPFLAG=-cpp
WFLAGS=-W1 -DMSW
CFLAGS_=-Jm -ml -C -2 $(DEBUG_FLAGS) $(PRIVATE_CC_FLAGS)
CCOBJ=$(CC) $(CFLAGS_) $(INC) -c 
CCEXE=$(CC) "=32768" $(CFLAGS_) $(INC) -o 
CCWOBJ=$(CC) $(WFLAGS) $(CFLAGS_) $(INC) -c 
CCWEXE=$(CC) "=32768" $(WFLAGS) $(CFLAGS_) $(INC) commdlg.lib -o 
OBJ2WEXE=$(CC) "=32768" $(WFLAGS) $(CFLAGS_) commdlg.lib -o 
endif

.cpp.obj:
	$(CCWOBJ) $<

.cc.obj:
	$(CCOBJ) $(CPPFLAG) $<

ifeq ($(VC), yes)
define ccwexe
	$(CCWOBJ) $(filter %.cpp,$^)
	$(OBJ2WEXE)$@ $(subst .cpp,.obj,$(filter %.cpp,$^)) $(LWLIB) $(filter %.def,$^)
	$(RC) $(INC) $(filter %.rc,$^) $@
endef
else
define ccwexe
	$(CCWOBJ) $(filter %.cpp,$^)
	$(OBJ2WEXE)$@ $(subst .cpp,.obj,$(filter %.cpp,$^)) $(LWLIB)
	$(RC) $(INC) $(filter %.rc,$^) $@
endef
endif

### speciall
all::
.PHONY: all

clean.back::
	$(RM) *~
	$(RM) *.*~
	$(RM) *.bak

clean:: clean.back
.PHONY: clean

ifeq ($(DOS), yes)
define enter
	@echo enter $@
	@cd $@
	@$(MAKE)
	@cd ..
endef
else
define enter
	echo enter $@;cd $@; $(MAKE); cd ..
endef
endif

ifeq ($(DOS), yes)
define enter_clean
	@echo clean $(subst .clean,,$@)
	@cd $(subst .clean,,$@)
	@$(MAKE) clean
	@cd ..
endef
else
define enter_clean
	@echo clean $(subst .clean,,$@); cd $(subst .clean,,$@); $(MAKE) clean; cd ..
endef
endif
