/* -------------------------------------------------------------------- */
/*                          Leaf class library				*/
/*           Copyright (c) 1992-4 by T.Kudou. All rights reserved.	*/
/*                                                                      */
/* config.h:                                                            */
/*                                                                      */
/* -------------------------------------------------------------------- */
/* $Header: /d/1/proj/egypt/0/leaf/src/RCS/config.h,v 1.4 1994/07/17 13:04:42 kudou Exp $ */

#ifndef _leaf_config_h
#define _leaf_config_h

/*
 * Compiler
 */

/* AT&T cfront Ver.3.0  */
/* When you use cfront 3.0, define CFRONT3. */
#ifdef CFRONT3
#  define COMPILER cfront
#  define COMPILER_VERSION 2
#  define COMPILER_MINNOR_VERSION 1
#  define HAS_TEMPLATE
#  define _32BIT_C
#endif

/* SUN C++ Ver.2.1 (AT&T cfront) */
/* When you use cfront 2.1, define CFRONT21. */
#ifdef CFRONT21
#  define COMPILER cfront
#  define COMPILER_VERSION 2
#  define COMPILER_MINNOR_VERSION 1
#  define _32BIT_C
#endif

/* GNU g++ */
#ifdef __GNUC__
#  define COMPILER g_plus_plus
#  define COMPILER_VERSION __GNUC__
#  ifdef __GNUC_MINOR__
#    define COMPILER_MINNOR_VERSION __GNUC_MINOR__
#    define HAS_TEMPLATE
#  else
#    define COMPILER_MINNOR_VERSION 0
#  endif
#  define _32BIT_C
#endif

/* MSC and Visual C++ */
#ifdef _MSC_VER
#  define COMPILER cl
#  define COMPILER_VERSION _MSC_VER
#  define COMPILER_MINNOR_VERSION 0
#  if _MSC_VER >= 900
     /* may be */
#    define HAS_TEMPLATE
#  endif
#  ifdef _M_IX86
#    define _32BIT_C
#  else
#    define _16BIT_C
#  endif
#ifdef M_I86SM
#  define __SMALL__
#endif
#ifdef M_I86MM
#  define __MEDIUM__
#endif
#ifdef M_I86LM
#  define __LARGE__
#endif
#ifdef M_I86CM
#  define __COMPACT__
#endif
#endif

/* Borland C++ Ver.3.0/3.1/4.0 */
#ifdef __BORLANDC__
#  define COMPILER bcc
#  define COMPILER_VERSION __BORLANDC__
#  define COMPILER_MINNOR_VERSION 0
#  define HAS_TEMPLATE
/* _32BIT_C must be defined when you use 32bit code. 16bit is default */
#  ifndef _32BIT_C
#  define _16BIT_C
#  endif
#endif

/* Zortech C++ Ver.2.1 */
#if defined(__ZTC__) && !defined(__SC__)
#  define COMPILER ztc
#  define COMPILER_VERSION 2
#  define COMPILER_MINNOR_VERSION 1
#  undef HAS_TEMPLATE
#  define _16BIT_C
#endif

/* Symantec C++ Ver.6.0 */
#ifdef __SC__
#  define COMPILER sc
#  define COMPILER_VERSION 6
#  define COMPILER_MINNOR_VERSION 0
#  define HAS_TEMPLATE
#  if __INTSIZE == 2
#    define _16BIT_C
#  else /* __INTSIZE == 4 */
#    define _32BIT_C
#  endif
#endif

/*
 * misc
 */
#if !((COMPILER == cfront) && (COMPILER_VERSION <= 2))
#  define SUPPORT_SIGNED_CHAR
#endif

#if (COMPILER == cfront) && (COMPILER_VERSION <= 2)
/* cfront 2.1 causes bus error under next type context.
 * class Foo {
 * public:
 *   enum Bar { a_bar, b_bar, };
 * };
 * typedef enum Bar (*foo_bar_t)(void*); <<- ok
 * typedef Foo::Bar (*foo_bar_t)(void*); <<- bus error
 */
#  define ENUMPREFIX(T) enum /**/
#else
#  define ENUMPREFIX(T) T::
#endif

#if defined(sun)
#  define CHAR_P_MALLOC_T
#endif

#if defined(__GNUC__) || defined(__TURBOC__) || defined(__BORLANDC__) || defined(_MSC_VER)
#  define DONT_HAVE_GENERIC_H
#endif

#if defined(sun) && !defined(__GNUC__)
#  define DONT_HAVE_MEMMOVE
#endif

#ifdef HAS_TEMPLATE
#  ifndef NUSE_TEMPLATE
#    define USE_TEMPLATE
#  endif /* NUSE_TEMPLATE */
#endif /* HAS_TEMPLATE */

#include "misc.h"
 
#endif /* _leaf_config_h */
