// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// listtest.cc:
//
//        define TEMPLATE_TEST    don't define TEMPLATE_TEST     
// ---------------------------- +----------------------------
// XSLIST	XSList<T>		GXSList(T)
// XDLIST	XDList<T>		GXDList(T)
// XALIST	XAList<T>		GXAList(T)
// NSLIST	NSList<T>		GNSList(T)
// NDLIST	NDList<T>		GNDList(T)
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/listtest.cc,v 1.7 1994/07/14 09:04:11 kudou Exp $

extern "C"
{
#include <stdio.h>
}

#include "config.h"
#include "mdebug.h"

#ifndef TESTSIZE
#  define TESTSIZE 10
#endif

#if TESTSIZE < 10
//#   error TESTSIZE must be more than 10
#endif

class Foo; // forward ref.

#ifdef NSLIST
#  include "nslist.h"
#  ifdef TEMPLATE_TEST
typedef NSList<Foo>	     FooList;
typedef NSListIterator<Foo>  FooListIterator;
#  else
GNSListDeclare(Foo)
typedef GNSList(Foo)	     FooList;
typedef GNSListIterator(Foo) FooListIterator;
#  endif
#endif

#ifdef NDLIST
#  include "ndlist.h"
#  ifdef TEMPLATE_TEST
typedef NDList<Foo>	     FooList;
typedef NDListIterator<Foo>  FooListIterator;
#  else
GNDListDeclare(Foo)
typedef GNDList(Foo)	     FooList;
typedef GNDListIterator(Foo) FooListIterator;
#  endif
#endif

#ifdef XSLIST
#  include "xslist.h"
#  ifdef TEMPLATE_TEST
typedef XSList<Foo>          FooList;
typedef XSListIterator<Foo>  FooListIterator;
#  else
GXSListDeclare(Foo)
typedef GXSList(Foo)         FooList;
typedef GXSListIterator(Foo) FooListIterator;
#  endif
#endif
  
#ifdef XDLIST
#  include "xdlist.h"
#  ifdef TEMPLATE_TEST
typedef XDList<Foo>          FooList;
typedef XDListIterator<Foo>  FooListIterator;
#  else
GXDListDeclare(Foo)
typedef GXDList(Foo)         FooList;
typedef GXDListIterator(Foo) FooListIterator;
#  endif
#endif
  
#ifdef XALIST
#  include "xalist.h"
#  ifdef TEMPLATE_TEST
typedef XAList<Foo>          FooList;
typedef XAListIterator<Foo>  FooListIterator;
#  else
GXAListDeclare(Foo)
typedef GXAList(Foo)         FooList;
typedef GXAListIterator(Foo) FooListIterator;
#  endif
#endif

// sample list item class
class Foo
#ifdef NSLIST
#  ifdef TEMPLATE_TEST
: public NSListItem<Foo>
#  else
: public GNSListItem(Foo)
#  endif
#endif
#ifdef NDLIST
#  ifdef TEMPLATE_TEST
: public  NDListItem<Foo>
#  else
: public  GNDListItem(Foo)
#  endif
#endif
{
  unsigned int num;
 public:
  Foo (unsigned int num) { Foo::num = num; }
  void Show () { printf ("%5d ", num); }
  static void ShowElement (void* this__);
};

void
Foo::ShowElement (void* this__)
{
  Foo* this_ = (Foo*)this__;
  printf ("[%d]\n", this_->num);
}
  
class TestList
{
  // debug list
  FooList* fl;
  
 public:
  // constructor
  TestList ();
  TestList (uword num);
  
  // destructor
  ~TestList ();
  
  // make sample list
  void Make (uword num);
  
  // clear sample list
  void Clear ();
  
  // show
  void Show ();
  
  // test
  void PushPopTest ();
  void EjectInjectTest ();
  void ClearTest ();
  void InsertTest ();
  void ExchangeTest ();
  void SwapTest ();
  void ComplexPatternTest ();
};

TestList::TestList ()
{
  fl = new FooList ();
}

TestList::~TestList ()
{
  Clear ();
  delete fl;
}

void
TestList::Make (uword num)
{
  fl->Clear ();
  for (uword n = 1; n <= num; n++)
  {
    fl->Inject (new Foo (n));
  }
}

void
TestList::Clear ()
{
#if !defined(NSLIST) && !defined(NDLIST)
  FooListIterator fli (fl);
  for (Foo* foo = 0; (foo = fli ()) != 0; )
  {
    delete foo;
  }
#endif
  fl->Clear ();
}

void
TestList::Show ()
{
  // total Number () check
  printf (" Num :%d", fl->Number ());
  printf (" Head :");
  if (fl->Head () != 0)
  {
    // Head () Value
    fl->Head ()->Show ();
  }
  else
  {
    printf (" null ");
  }
  printf (" Tail :");
  if (fl->Tail () != 0)
  {
    // Tail () Value
    fl->Tail ()->Show ();
  }
  else
  {
    printf (" null ");
  }
  printf ("\n Contents :");
  // EmptyP () check
  if (fl->EmptyP () == True)
  {
    // Number () check!
    if (fl->Number () != 0)
    {
      printf ("EmptyP is True, but Number isn't 0!!!\n");
    }
    printf (" null \n\n");
    return;
  }
  FooListIterator fli (fl);
  Foo* foo;
  Foo* prev = 0;
  Foo* next = fl->Head ();
  unsigned int n = 1;
  while ((foo = fli ()) != 0)
  {
    // content show
    foo->Show ();
    // access () check
    if (fl->Access (n) != foo)
    {
      printf ("Access and Iterator is different!!!");
    }
    // [] check
    if ((*fl)[n - 1] != foo)
    {
      printf ("[] and Iterator is different!!!");
    }
    n++;
    // Prev () check!    
    if (fl->Prev (foo) != prev)
    {
      printf ("Prev () is funny!!!");
    }
    // Next () check!
    if (next != foo)
    {
      printf ("Next () is funny!!!");
    }
    
    prev = foo;
    next = fl->Next (foo);
  }
  printf ("\n\n");
}

void
TestList::PushPopTest ()
{
  printf ("** Push and Pop Test **\n");
  
  // Push () test 
  printf ("push list\n");
  for (uword i = 1; i <= TESTSIZE; i++)
  {
    fl->Push (new Foo (i));
  }
  
  // push list
  Show ();
  
  // Pop () test
  printf ("pop list\n");
  for (i = 1; i <= TESTSIZE; i++)
  {
    Foo* foo = fl->Pop ();
    foo->Show ();
    delete foo;
  }
  printf ("\n");
  
  // empty list
  Show ();
}

void
TestList::EjectInjectTest ()
{
  printf ("** Eject and Inject Test **\n");
  
  // Inject () test
  printf ("inject list\n");
  for (uword i = 1; i <= TESTSIZE; i++)
  {
    fl->Inject (new Foo (i));
  }
  
  // inject list
  Show ();
  
  // Eject () list
  printf ("eject list\n");
  for (i = 1; i <= TESTSIZE; i++)
  {
    Foo* foo = fl->Eject ();
    foo->Show ();
    delete foo;
  }
  printf ("\n");
  
  // empty list
  Show ();
}

void
TestList::ClearTest ()
{
  printf ("** Clear Test **\n");
  Make (TESTSIZE);
  Show ();
#if !defined(NSLIST) && !defined(NDLIST)
  FooListIterator fli (fl);
  for (Foo* foo = 0; (foo = fli ()) != 0; )
  {
    delete foo;
  }
#endif
  fl->Clear ();
  Show ();
}

void
TestList::InsertTest ()
{
  printf ("** Insert Test **\n");
  
  // insert Before by position
  printf ("insert Before by position\n");
  Make (TESTSIZE);
  printf ("first pos\n");
  // first position
  fl->InsertBefore (new Foo (0), 1);
  Show ();
  
  printf ("last pos\n");
  // last position
  fl->InsertBefore (new Foo (0), TESTSIZE+1);
  Show ();
  
  printf ("middle pos\n");
  // middle position
  fl->InsertBefore (new Foo (0), (TESTSIZE+2)/2);
  Show ();
  
  // insert Before by item
  printf ("insert Before by item\n");
  Clear ();
  Make (TESTSIZE);
  Foo* top    = fl->Head ();
  // first position
  fl->InsertBefore (new Foo (0), top);
  printf ("first pos\n");
  Show ();
  
  Foo* tail   = fl->Tail ();
  // last position
  fl->InsertBefore (new Foo (0), tail);
  printf ("last pos\n");
  Show ();
  
  Foo* middle = fl->Access ((TESTSIZE+2)/2);
  // middle position
  fl->InsertBefore (new Foo (0), middle);
  printf ("middle pos\n");
  Show ();
  
  // insert after by position
  printf ("insert after by position\n");
  Clear ();
  Make (TESTSIZE);
  // first position
  fl->InsertAfter (new Foo (0), 1);
  printf ("first pos\n");
  Show ();
  
  // last position
  fl->InsertAfter (new Foo (0), TESTSIZE+1);
  printf ("last pos\n");
  Show ();
  
  // middle position
  fl->InsertAfter (new Foo (0), (TESTSIZE+2)/2);
  printf ("middle pos\n");
  Show ();
  
  // insert after by item
  printf ("insert after by item\n");
  Clear ();
  Make (TESTSIZE);
  top    = fl->Head ();
  // first position
  fl->InsertAfter (new Foo (0), top);
  printf ("first pos\n");
  Show ();
  
  tail   = fl->Tail ();
  // last position
  fl->InsertAfter (new Foo (0), tail);
  printf ("last pos\n");
  Show ();
  
  middle = fl->Access ((TESTSIZE+2)/2);
  // middle position
  fl->InsertAfter (new Foo (0), middle);
  printf ("middle pos\n");
  Show ();
}

void
TestList::ExchangeTest ()
{
  printf ("** Exchange Test **\n");
  
  // exchange by position
  printf ("exchange by position\n");
  Make (TESTSIZE);
  Foo* f = fl->Access (1);
  // first position
  fl->ExchangeItem (new Foo (0), 1);
  delete f;
  printf ("first pos\n");
  Show ();
  
  f = fl->Access (TESTSIZE);
  // last position
  fl->ExchangeItem (new Foo (0), TESTSIZE);
  delete f;
  printf ("last pos\n");
  Show ();
  
  f = fl->Access (TESTSIZE/2);
  // middle position
  fl->ExchangeItem (new Foo (0), TESTSIZE/2);
  delete f;
  printf ("middle pos\n");
  Show ();
  
  // exchange by item
  printf ("exchange by item\n");
  Clear ();
  Make (TESTSIZE);
  f = fl->Head ();
  // first position
  fl->ExchangeItem (new Foo (0), f);
  delete f;
  printf ("first pos\n");
  Show ();
  
  f = fl->Tail ();
  // last position
  fl->ExchangeItem (new Foo (0), f);
  delete f;
  printf ("last pos\n");
  Show ();
  
  f = fl->Access (TESTSIZE/2);
  fl->ExchangeItem (new Foo (0), f);
  delete f;
  printf ("middle pos\n");
  Show ();
}

void
TestList::SwapTest ()
{
  printf ("** Swap Test **\n");
  
  // swap by position
  printf ("swap by position\n");
  Make (TESTSIZE);
  // swap top and tail
  fl->SwapItem (1, TESTSIZE);
  printf ("top and tail\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  // swap top and middle
  fl->SwapItem (1, TESTSIZE/2);
  printf ("top and middle\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  // swap middle and tail
  fl->SwapItem (TESTSIZE/2, TESTSIZE);
  printf ("middle and tail");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  // second and Before tail
  fl->SwapItem (2, TESTSIZE - 1);
  printf ("second and Before tail\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  // same position
  fl->SwapItem (TESTSIZE/2, TESTSIZE/2);
  printf ("middle same pos");
  Show ();
  
  // swap by item
  printf ("swap by item\n");
  Clear ();
  Make (TESTSIZE);
  Foo* f1 = fl->Access (1);
  Foo* f2 = fl->Access (TESTSIZE);
  // swap top and tail
  fl->SwapItem (f1, f2);
  printf ("top and tail\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  f1 = fl->Access (1);
  f2 = fl->Access (TESTSIZE/2);
  // swap top and middle
  fl->SwapItem (f1, f2);
  printf ("top and middle\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  f1 = fl->Access (TESTSIZE/2);
  f2 = fl->Access (TESTSIZE);
  // swap middle and tail
  fl->SwapItem (f1, f2);
  printf ("middle and tail");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  f1 = fl->Access (2);
  f2 = fl->Access (TESTSIZE - 1);
  // second and Before tail
  fl->SwapItem (f1, f2);
  printf ("second and Before tail\n");
  Show ();
  
  Clear ();
  Make (TESTSIZE);
  f1 = fl->Access (TESTSIZE/2);
  // same position
  fl->SwapItem (f1, f1);
  printf ("middle same pos");
  Show ();
}

void
TestList::ComplexPatternTest ()
{
  Clear ();
  Foo* f1  = new Foo (1);
  Foo* f2  = new Foo (2);
  Foo* f3  = new Foo (3);
  Foo* f4  = new Foo (4);
  Foo* f5  = new Foo (5);
  Foo* f6  = new Foo (6);
  Foo* f7  = new Foo (7);
  Foo* f8  = new Foo (8);
  Foo* f9  = new Foo (9);
  Foo* f10 = new Foo (10);
  
  fl->Push (f3);
  fl->InsertBefore (f1, f3);
  fl->InsertAfter (f2, f1);
  fl->InsertAfter (f8, f3);
  fl->InsertBefore (f7, f8);
  fl->InsertBefore (f5, f7);
  fl->InsertBefore (f4, f5);
  fl->InsertAfter (f6, f5);
  fl->InsertAfter (f10, f8);
  fl->InsertBefore (f9, f10);
  
  Show ();
  Clear ();
}

int
main ()
{
  {
    TestList t1;
    t1.PushPopTest ();
    TestList t2;
    t2.EjectInjectTest ();
    TestList t3;
    t3.ClearTest ();
    TestList t4;
    t4.InsertTest ();
    TestList t5;
    t5.ExchangeTest ();
    TestList t6;
    t6.SwapTest ();
    TestList t7;
    t7.ComplexPatternTest ();
  }
  printf("memory count :%ld\n", get_memory_count ());
  return 0;
}
