// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// ndlist.cc:
//
// eNdogenous(I) Double List
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/ndlist.cc,v 1.10 1994/05/02 14:46:49 kudou Exp $

#if defined(__GNUC__) && defined(EXTERNAL_TEMPLATES)
#pragma implementation "ndlist.h"
#endif

#include "ndlist.h"

void
_NDList::_Push (_NDListItem* item)
{
  item->_SetPrev (0);
  item->_SetNext (GetTop ());
  if (GetTop () != 0)
  {
    GetTop ()->_SetPrev (item);
  }
  else
  {
    SetTail (item);
  }
  SetTop (item);
}

void
_NDList::_Push (_NDList& list)
{
  if (list.GetTail () != 0)
  {
    list.GetTail ()->_SetNext (GetTop ());
    if (GetTop () != 0)
    {
      GetTop ()->_SetPrev (list.GetTail ());
    }
    else
    {
      SetTail (list.GetTail ());
    }
    SetTop (list.GetTop ());
    list.SetTop (0);
    list.SetTail (0);
  }
}

_NDListItem*
_NDList::_Pop ()
{
  _NDListItem* item = GetTop ();
  _Delete (item);
  return item;
}

void
_NDList::_Inject (_NDListItem* item)
{
  item->_SetPrev (GetTail ());
  item->_SetNext (0);
  if (GetTail () != 0)
  {
    GetTail ()->_SetNext (item);
  }
  else
  {
    SetTop (item);
  }
  SetTail (item);
}

void
_NDList::_Inject (_NDList& list)
{
  if (list.GetTop () != 0)
  {
    list.GetTop ()->_SetPrev (GetTail ());
    if (GetTail () != 0)
    {
      GetTail ()->_SetNext (list.GetTop ());
    }
    else
    {
      SetTop (list.GetTop ());
    }
    SetTail (list.GetTail ());
    list.SetTop (0);
    list.SetTail (0);
  }
}

_NDListItem*
_NDList::_Eject ()
{
  _NDListItem* item = GetTail ();
  _Delete (tail);
  return item;
}

void
_NDList::_InsertBefore (_NDListItem* item, unsigned int pos)
{
  _NDListItem* s = _Access (pos);
  if (s != 0)
  {
    _InsertBefore (item, s);
  }
}

void
_NDList::_InsertBefore (_NDListItem* item, _NDListItem* pos)
{
  item->_SetNext (pos);
  item->_SetPrev (pos->_GetPrev ());
  if (pos->_GetPrev () != 0)
  {
    pos->_GetPrev ()->_SetNext (item);
  }
  else
  {
    SetTop (item);
  }
  pos->_SetPrev (item);
}

void
_NDList::_InsertAfter (_NDListItem* item, unsigned int pos)
{
  _NDListItem* s = _Access (pos);
  if (s != 0)
  {
    _InsertAfter (item, s);
  }
}

void
_NDList::_InsertAfter (_NDListItem* item, _NDListItem* pos)
{
  item->_SetNext (pos->_GetNext ());
  item->_SetPrev (pos);
  if (pos->_GetNext () != 0)
  {
    pos->_GetNext ()->_SetPrev (item);
  }
  else
  {
    SetTail (item);
  }
  pos->_SetNext (item);
}

void
_NDList::_Delete (_NDListItem* item)
{
  if (item->_GetPrev () != 0)
  {
    item->_GetPrev ()->_SetNext (item->_GetNext ());
  }
  else
  {
    SetTop (item->_GetNext ());
  }
  if (item->_GetNext () != 0)
  {
    item->_GetNext ()->_SetPrev (item->_GetPrev ());
  }
  else
  {
    SetTail (item->_GetPrev ());
  }
  item->_SetPrev (0);
  item->_SetNext (0);
}

void
_NDList::_Delete (unsigned int pos)
{
  _NDListItem* s = _Access (pos);
  if (s != 0)
  {
    _Delete (s);
  }
}

void
_NDList::_Clear ()
{
  _NDListItem* s = GetTop ();
  while (s != 0)
  {
    _NDListItem* next = s->_GetNext ();
    delete s;
    s = next;
  }
  SetTop (0);
  SetTail (0);
}

void
_NDList::_ExchangeItem (_NDListItem* item, _NDListItem* pos)
{
  item->_SetPrev (pos->_GetPrev ());
  item->_SetNext (pos->_GetNext ());
  if (pos->_GetPrev () != 0)
  {
    pos->_GetPrev ()->_SetNext (item);
  }
  else
  {
    SetTop (item);
  }
  if (pos->_GetNext () != 0)
  {
    pos->_GetNext ()->_SetPrev (item);
  }
  else
  {
    SetTail (item);
  }
  pos->_SetPrev (0);
  pos->_SetNext (0);
}

void
_NDList::_ExchangeItem (_NDListItem* item, unsigned int pos)
{
  _NDListItem* s = _Access (pos);
  if (s != 0)
  {
    _ExchangeItem (item, s);
  }
}

void
_NDList::_SwapItem (_NDListItem* i1, _NDListItem* i2)
{
  _NDListItem* i1_prev = i1->_GetPrev ();
  _NDListItem* i1_next = i1->_GetNext ();
  _NDListItem* i2_prev = i2->_GetPrev ();
  _NDListItem* i2_next = i2->_GetNext ();
  i1->_SetPrev (i2_prev);
  i1->_SetNext (i2_next);
  i2->_SetPrev (i1_prev);
  i2->_SetNext (i1_next);
  if (i1_prev != 0)
  {
    i1_prev->_SetNext (i2);
  }
  else
  {
    SetTop (i2);
  }
  if (i1_next != 0)
  {
    i1_next->_SetPrev (i2);
  }
  else
  {
    SetTail (i2);
  }
  if (i2_prev != 0)
  {
    i2_prev->_SetNext (i1);
  }
  else
  {
    SetTop (i1);
  }
  if (i2_next != 0)
  {
    i2_next->_SetPrev (i1);
  }
  else
  {
    SetTail (i1);
  }
}

void
_NDList::_SwapItem (unsigned int n1, unsigned int n2)
{
  _NDListItem* i1 = _Access (n1);
  _NDListItem* i2 = _Access (n2);
  if ((i1 != 0) && (i2 != 0))
  {
    _SwapItem (i1, i2);
  }
}
