// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// ndlist.h:
//
// eNdogenous(I) Double List
//
// template version
// class NDList<T>
// class NDListItem<T>
// class NDListIterator<T>
//
// generic macro version
// class GNDList(T)
// class GNDListItem(T)
// class GNDListIterator(T)
//
// e\bhɂĂ "nlistm.h" QƂ̂
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/ndlist.h,v 1.10 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_ndlist_h
#define _leaf_ndlist_h

#if defined(__GNUC__) && defined(EXTERNAL_TEMPLATES)
#pragma interface
#endif

#include "nslist.h"

class _NDListItem
: private _NSListItem
{
  friend class _NDList;

  _NDListItem* prev;

 public:
  _NDListItem (_NDListItem* prev, _NDListItem* next)
  : _NSListItem (next) { _NDListItem::prev = prev; }
  ~_NDListItem () { ; }
  _NDListItem* _GetNext () { return (_NDListItem*)_NSListItem::_GetNext (); }
  void _SetNext (_NDListItem* n) { _NSListItem::_SetNext (n); }
  _NDListItem* _GetPrev () { return prev; }
  void _SetPrev (_NDListItem* p) { prev = p; }
  void _Set (_NDListItem* prev, _NDListItem* next)
  {
    _SetPrev (prev);
    _SetNext (next);
  }
};

class _NDList
: private _NSList
{
  _NDListItem* tail;

 protected:
  _NDListItem* GetTail () { return tail; }
  void SetTail (_NDListItem* t) { tail = t; }
  _NDListItem* GetTop () { return (_NDListItem*)_NSList::GetTop (); }
  void SetTop (_NDListItem* t) { _NSList::SetTop (t); }

 public:
  _NDList () : _NSList () { tail = 0; }
  ~_NDList () { ; }
  bool _EmptyP () { return _NSList::_EmptyP (); }
  unsigned int _Number () { return _NSList::_Number (); }
  _NDListItem* _Access (unsigned int n)
    { return (_NDListItem*)_NSList::_Access (n); }
  _NDListItem* _Prev (_NDListItem* item)
    { return (item != 0) ? item->_GetPrev () : 0; }
  _NDListItem* _Next (_NDListItem* item)
    { return (item != 0) ? item->_GetNext () : 0; }
  _NDListItem* _Head () { return (_NDListItem*)_NSList::_Head (); }
  _NDListItem* _Tail () { return tail; }
  void _Push (_NDListItem* item);
  void _Push (_NDList& list);
  _NDListItem* _Pop ();
  void _Inject (_NDListItem* item);
  void _Inject (_NDList& list);
  _NDListItem* _Eject ();
  void _InsertBefore (_NDListItem* item, unsigned int pos);
  void _InsertBefore (_NDListItem* item, _NDListItem* pos);
  void _InsertAfter (_NDListItem* item, unsigned int pos);
  void _InsertAfter (_NDListItem* item, _NDListItem* pos);
  void _Delete (_NDListItem* item);
  void _Delete (unsigned int pos);
  void _Clear ();
  void _ExchangeItem (_NDListItem* item, _NDListItem* pos);
  void _ExchangeItem (_NDListItem* item, unsigned int pos);
  void _SwapItem (_NDListItem* i1, _NDListItem* i2);
  void _SwapItem (unsigned int n1, unsigned int n2);
};

class _NDListIterator 
{
  _NDList& list;
  _NDListItem* node;

 public:
  void Revert () { node = list._Head (); }
  _NDListIterator (_NDList& l) : list(l) { Revert (); }
  _NDListItem* operator () ()
  {
    _NDListItem* ret = node;
    node = node ? node->_GetNext () : 0;
    return ret;
  }
};

// template version
#ifdef HAS_TEMPLATE
// CAUTION: class T must be derived from NDListItem
template <class T>
class NDListItem
: public _NDListItem
{
 public:
  NDListItem (T* prev = 0, T* next = 0)
  : _NDListItem ((_NDListItem*)((NDListItem<T>*)prev),
		 (_NDListItem*)((NDListItem<T>*)next)) { ; }
  ~NDListItem () { ; }
  T* GetNext () { return (T*)((NDListItem<T>*)_GetNext ());  }
  void SetNext (T* next) { _SetNext ((_NDListItem*)((NDListItem<T>*)next)); }
  T* GetPrev () { return (T*)((NDListItem<T>*)_GetPrev ());  }
  void SetPrev (T* next) { _SetPrev ((_NDListItem*)((NDListItem<T>*)next)); }
};

template <class T>
class NDList
: public _NDList
{
 public:
  NDList () { ; }
  ~NDList () { ; }

#define LIST_T NDList<T>
#define LISTITEM_T NDListItem<T>
#include "nlistm.h"
#undef LIST_T
#undef LISTITEM_T
};

template <class T>
class NDListIterator
{
  _NDListIterator ndi;
 public:
  NDListIterator (NDList<T>& l) : ndi(l) { ; }
  NDListIterator (NDList<T>* l) : ndi(*l) { ; }
  T* operator () () { return (T *)((NDListItem<T>*)ndi ()); }
  void Revert () { ndi.Revert (); }
};

#endif /* HAS_TEMPLATE */

// generic macro version
#include "generic.h"

#define GNDList(T) name2(GNDList_,T)
#define GNDListItem(T) name2(GNDListItem_,T)
#define GNDListIterator(T) name2(GNDListIterator_,T)

#define GNDListDeclare(T)						\
class GNDListItem(T)							\
: public _NDListItem							\
{									\
 public:								\
  GNDListItem(T) (T* prev = 0, T* next = 0)				\
  : _NDListItem ((_NDListItem*)((GNDListItem(T)*)prev),			\
		 (_NDListItem*)((GNDListItem(T)*)next)) { ; }		\
  ~GNDListItem(T) () { ; }						\
  T* GetNext () { return (T*)((GNDListItem(T)*)_GetNext ());  }		\
  void SetNext (T* next)						\
    { _SetNext ((_NDListItem*)((GNDListItem(T)*)next)); }		\
};									\
									\
class GNDList(T)							\
: public _NDList							\
{									\
 public:								\
  GNDList(T) () { ; }							\
  ~GNDList(T) () { ; }							\
  bool EmptyP () { return _EmptyP (); }					\
  unsigned int Number () { return _Number (); }				\
  T* Access (unsigned int n)						\
    { return (T*)((GNDListItem(T)*)_Access (n)); }			\
  T* operator [] (unsigned int n)					\
    { return (T*)((GNDListItem(T)*)_Access (n + 1)); }			\
  T* Prev (T* item)							\
    { return (T*)((GNDListItem(T)*)_Prev ((GNDListItem(T)*)item)); }	\
  T* Next (T* item)							\
    { return (T*)((GNDListItem(T)*)_Next ((GNDListItem(T)*)item)); }	\
  T* Head () { return (T*)((GNDListItem(T)*)_Head ()); }		\
  T* Tail () { return (T*)((GNDListItem(T)*)_Tail ()); }		\
  void Push (T* item) { _Push ((GNDListItem(T)*)item); }		\
  void Push (GNDList(T)& list) { _Push (list); }			\
  T* Pop () { return (T*)((GNDListItem(T)*)_Pop ()); }			\
  void Inject (T* item) { _Inject ((GNDListItem(T)*)item); }		\
  void Inject (GNDList(T)& list) { _Inject (list); }			\
  T* Eject () { return (T*)((GNDListItem(T)*)_Eject ()); }		\
  void InsertBefore (T* item, unsigned int pos)				\
    { _InsertBefore ((GNDListItem(T)*)item, pos);	}		\
  void InsertBefore (T* item, T* pos)					\
    { _InsertBefore ((GNDListItem(T)*)item, (GNDListItem(T)*)pos); }	\
  void InsertAfter (T* item, unsigned int pos)				\
    { _InsertAfter ((GNDListItem(T)*)item, pos);	}		\
  void InsertAfter (T* item, T* pos)					\
    { _InsertAfter ((GNDListItem(T)*)item, (GNDListItem(T)*)pos); }	\
  void Delete (T* item) { _Delete ((GNDListItem(T)*)item); }		\
  void Delete (unsigned int pos) { _Delete (pos); }			\
  void Clear () { _Clear (); }						\
  void ExchangeItem (T* item, T* pos)					\
    { _ExchangeItem ((GNDListItem(T)*)item, (GNDListItem(T)*)pos); }	\
  void ExchangeItem (T* item, unsigned int pos)				\
    { _ExchangeItem ((GNDListItem(T)*)item, pos); }			\
  void SwapItem (T* i1, T* i2)						\
    { _SwapItem ((GNDListItem(T)*)i1, (GNDListItem(T)*)i2); }		\
  void SwapItem (unsigned int n1, unsigned int n2)			\
    { _SwapItem (n1, n2); }						\
};									\
									\
class GNDListIterator(T)						\
{									\
  _NDListIterator ndi;							\
 public:								\
  GNDListIterator(T) (GNDList(T)& l) : ndi(l) { ; }			\
  GNDListIterator(T) (GNDList(T)* l) : ndi(*l) { ; }			\
  T* operator () () { return (T *)((GNDListItem(T)*)ndi ()); }		\
  void Revert () { ndi.Revert (); }					\
};									\

#endif /* _leaf_ndlist_h */
