// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// nslist.cc:
//
// eNdogenous(I) Single List
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/nslist.cc,v 1.12 1994/05/02 14:46:49 kudou Exp $

#if defined(__GNUC__) && defined(EXTERNAL_TEMPLATES)
#pragma implementation "nslist.h"
#endif

#include "nslist.h"

unsigned int
_NSList::_Number ()
{
  unsigned int n = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    n++;
  }
  return n;
}

_NSListItem*
_NSList::_Access (unsigned int n)
{
  unsigned int i = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == n)
    {
      return s;
    }
  }
  return 0;
}

_NSListItem*
_NSList::_Prev (_NSListItem* item)
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == item)
    {
      return prev;
    }
    prev = s;
  }
  return 0;
}

_NSListItem*
_NSList::_Tail ()
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    prev = s;
  }
  return prev;
}

void
_NSList::_Push (_NSListItem* item)
{
  item->_SetNext (top);
  top = item;
}

void
_NSList::_Push (_NSList& list)
{
  _NSListItem* tail = list._Tail ();
  if (tail != 0)
  {
    tail->_SetNext (top);
    top = list._Head ();
    list.SetTop (0);
  }
}

_NSListItem*
_NSList::_Pop ()
{
  _NSListItem* ret = top;
  top = top->_GetNext ();
  ret->_Unlink ();
  return ret;
}

void
_NSList::_Inject (_NSListItem* item)
{
  _NSListItem* tail = _Tail ();
  if (tail != 0)
  {
    tail->_SetNext (item);
  }
  else
  {
    top = item;
  }
  item->_SetNext (0);
}

void
_NSList::_Inject (_NSList& list)
{
  _NSListItem* tail = _Tail ();
  _NSListItem* list_head = list._Head ();
  if (list_head != 0)
  {
    if (tail != 0)
    {
      tail->_SetNext (list_head);
    }
    else
    {
      top = list_head;
    }
  }
  list.SetTop (0);
}

_NSListItem*
_NSList::_Eject ()
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s->_GetNext () == 0)
    { 
      if (prev)
      {
	prev->_SetNext (0);
      }
      else
      {
	top = 0;
      }
      s->_Unlink ();
      return s;
    }
    prev = s;
  }
  return 0;
}

void
_NSList::_InsertBefore (_NSListItem* item, unsigned int pos)
{
  unsigned int i = 0;
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	item->_SetNext (prev->_GetNext ());
	prev->_SetNext (item);
      }
      else 
      {
	item->_SetNext (top);
	top = item;
      }
      return;
    }
    prev = s;
  }
}

void
_NSList::_InsertBefore (_NSListItem* item, _NSListItem* pos)
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == pos)
    {
      if (prev != 0)
      {
	item->_SetNext (prev->_GetNext ());
	prev->_SetNext (item);
      }
      else 
      {
	item->_SetNext (top);
	top = item;
      }
      return;
    }
    prev = s;
  }
}

void
_NSList::_InsertAfter (_NSListItem* item, unsigned int pos)
{
  unsigned int i = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == pos)
    {
      item->_SetNext (s->_GetNext ());
      s->_SetNext (item);
      return;
    }
  }
}

void
_NSList::_InsertAfter (_NSListItem* item, _NSListItem* pos)
{
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == pos)
    {
      item->_SetNext (s->_GetNext ());
      s->_SetNext (item);
      return;
    }
  }
}

void
_NSList::_Delete (_NSListItem* item)
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == item)
    {
      if (prev != 0)
      {
	prev->_SetNext (s->_GetNext ());
      }
      else
      {
	top = s->_GetNext ();
      }
      item->_Unlink ();
      return;
    }
    prev = s;
  }
}

void
_NSList::_Delete (unsigned int pos)
{
  unsigned int i = 0;
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	prev->_SetNext (s->_GetNext ());
      }
      else
      {
	top = s->_GetNext ();
      }
      s->_Unlink ();
      return;
    }
    prev = s;
  }
}

void
_NSList::_Clear ()
{
  _NSListItem* s = top;
  while (s != 0)
  {
    _NSListItem* next = s->_GetNext ();
    delete s;
    s = next;
  }
  top = 0;
}

void
_NSList::_ExchangeItem (_NSListItem* item, _NSListItem* pos)
{
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == pos)
    {
      if (prev != 0)
      {
	prev->_SetNext (item);
      }
      else
      {
	top = item; 
      }
      item->_SetNext (s->_GetNext ());
      pos->_Unlink ();
      return;
    }
    prev = s;
  }
}

void
_NSList::_ExchangeItem (_NSListItem* item, unsigned int pos)
{
  unsigned int i = 0;
  _NSListItem* prev = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == pos)
    {
      if (prev != 0)
      {
	prev->_SetNext (item);
      }
      else
      {
	top = item; 
      }
      item->_SetNext (s->_GetNext ());
      s->_Unlink ();
      return;
    }
    prev = s;
  }
}

void
_NSList::_SwapItem (_NSListItem* i1, _NSListItem* i2,
		    _NSListItem* i1_prev, _NSListItem* i2_prev)
{
  _NSListItem* i1_next = i1->_GetNext ();
  _NSListItem* i2_next = i2->_GetNext ();
  if (i1_prev != 0)
  {
    i1_prev->_SetNext (i2);
  }
  else
  {
    top = i2;
  }
  i2->_SetNext (i1_next);
  if (i2_prev != 0)
  {
    i2_prev->_SetNext (i1);
  }
  else
  {
    top = i1;
  }
  i1->_SetNext (i2_next);
}

void
_NSList::_SwapItem (_NSListItem* i1, _NSListItem* i2)
{
  if (i1 == i2)
  {
    return;
  }
  _NSListItem* prev = 0;
  _NSListItem* i1_prev = 0;
  _NSListItem* i2_prev = 0;
  bool i1_prev_fix_p = False;
  bool i2_prev_fix_p = False;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (s == i1)
    {
      i1_prev = prev;
      i1_prev_fix_p = True; 
    }
    if (s == i2)
    {
      i2_prev = prev;
      i2_prev_fix_p = True; 
    }
    if (i1_prev_fix_p && i2_prev_fix_p)
    {
      break;
    }
    prev = s;
  }
  if (i1_prev_fix_p && i2_prev_fix_p)
  {
    _SwapItem (i1, i2, i1_prev, i2_prev);
  }
}

void
_NSList::_SwapItem (unsigned int n1, unsigned int n2)
{
  if (n1 == n2)
  {
    return;
  }
  _NSListItem* prev = 0;
  _NSListItem* i1 = 0;
  _NSListItem* i2 = 0;
  _NSListItem* i1_prev = 0;
  _NSListItem* i2_prev = 0;
  unsigned int i = 0;
  for (_NSListItem* s = top; s != 0; s = s->_GetNext ())
  {
    if (++i == n1)
    {
      i1 = s;
      i1_prev = prev;
    }
    if (i == n2)
    {
      i2 = s;
      i2_prev = prev;
    }
    if (i1 != 0 && i2 != 0)
    {
      break;
    }
    prev = s;
  }
  if (i1 != 0 && i2 != 0)
  {
    _SwapItem (i1, i2, i1_prev, i2_prev);
  }
}
