// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// nslist.h:
//
// eNdogenous(I) Single List
//
// template version
// class NSList<T>
// class NSListItem<T>
// class NSListIterator<T>
//
// generic macro version
// class GNSList(T)
// class GNSListItem(T)
// class GNSListIterator(T)
//
// e\bhɂĂ "nlistm.h" QƂ̂
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/nslist.h,v 1.11 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_nslist_h
#define _leaf_nslist_h

#if defined(__GNUC__) && defined(EXTERNAL_TEMPLATES)
#pragma interface
#endif

#include "typedef.h"

class _NSListItem
{
  _NSListItem* next;

 public:
  _NSListItem (_NSListItem* next = 0) { _NSListItem::next = next; }
  ~_NSListItem () { ; }
  _NSListItem* _GetNext () { return next; }
  void _SetNext (_NSListItem* n) { next = n; }
  void _Unlink () { next = 0; }
};

class _NSList
{
  _NSListItem* top;

 protected:
  _NSListItem* GetTop () { return top; }
  void SetTop (_NSListItem* t) { top = t; }

 public:
  _NSList () { top = 0; }
  ~_NSList () { _Clear (); }
  bool _EmptyP () { return top == 0; }
  unsigned int _Number ();
  _NSListItem* _Access (unsigned int n);
  _NSListItem* _Prev (_NSListItem* item);
  _NSListItem* _Next (_NSListItem* item)
    { return (item != 0) ? item->_GetNext () : 0; }
  _NSListItem* _Head () { return top; }
  _NSListItem* _Tail ();
  void _Push (_NSListItem* item);
  void _Push (_NSList& list);
  _NSListItem* _Pop ();
  void _Inject (_NSListItem* item);
  void _Inject (_NSList& list);
  _NSListItem* _Eject ();
  void _InsertBefore (_NSListItem* item, unsigned int pos);
  void _InsertBefore (_NSListItem* item, _NSListItem* pos);
  void _InsertAfter (_NSListItem* item, unsigned int pos);
  void _InsertAfter (_NSListItem* item, _NSListItem* pos);
  void _Delete (_NSListItem* item);
  void _Delete (unsigned int pos);
  void _Clear ();
  void _ExchangeItem (_NSListItem* item, _NSListItem* pos);
  void _ExchangeItem (_NSListItem* item, unsigned int pos);
  void _SwapItem (_NSListItem* i1, _NSListItem* i2);
  void _SwapItem (unsigned int n1, unsigned int n2);
 private:
  void _SwapItem (_NSListItem* i1, _NSListItem* i2,
		  _NSListItem* i1_prev, _NSListItem* i2_prev);
};

class _NSListIterator 
{
  _NSList& list;
  _NSListItem* node;

 public:
  void Revert () { node = list._Head (); }
  _NSListIterator (_NSList& l) : list(l) { Revert (); }
  _NSListItem* operator () ()
  {
    _NSListItem* ret = node;
    node = node ? node->_GetNext () : 0;
    return ret;
  }
};

// template version
#ifdef HAS_TEMPLATE
// CAUTION: class T must be derived from NSListItem
template <class T>
class NSListItem
: public _NSListItem
{
 public:
  NSListItem (T* next = 0)
    : _NSListItem ((_NSListItem*)((NSListItem<T>*)next)) { ; }
  ~NSListItem () { ; }
  T* GetNext () { return (T*)((NSListItem<T>*)_GetNext ());  }
  void SetNext (T* next) { _SetNext ((_NSListItem*)((NSListItem<T>*)next)); }
};

template <class T>
class NSList
: public _NSList
{
 public:
  NSList () { ; }
  ~NSList () { ; }

#define LIST_T NSList<T>
#define LISTITEM_T NSListItem<T>
#include "nlistm.h"
#undef LIST_T
#undef LISTITEM_T
};

template <class T>
class NSListIterator
{
  _NSListIterator nsi;
 public:
  NSListIterator (NSList<T>& l) : nsi(l) { ; }
  NSListIterator (NSList<T>* l) : nsi(*l) { ; }
  T* operator () () { return (T *)((NSListItem<T>*)nsi ()); }
  void Revert () { nsi.Revert (); }
};

#endif /* HAS_TEMPLATE */

// generic macro version
#include "generic.h"

#define GNSList(T) name2(GNSList_,T)
#define GNSListItem(T) name2(GNSListItem_,T)
#define GNSListIterator(T) name2(GNSListIterator_,T)

#define GNSListDeclare(T)						\
class GNSListItem(T)							\
: public _NSListItem							\
{									\
 public:								\
  GNSListItem(T) (T* next = 0)						\
  : _NSListItem ((_NSListItem*)((GNSListItem(T)*)next)) { ; }		\
  ~GNSListItem(T) () { ; }						\
  T* GetNext () { return (T*)((GNSListItem(T)*)_GetNext ());  }		\
  void SetNext (T* next)						\
    { _SetNext ((_NSListItem*)((GNSListItem(T)*)next)); }		\
};									\
									\
class GNSList(T)							\
: public _NSList							\
{									\
 public:								\
  GNSList(T) () { ; }							\
  ~GNSList(T) () { ; }							\
  bool EmptyP () { return _EmptyP (); }					\
  unsigned int Number () { return _Number (); }				\
  T* Access (unsigned int n) 						\
    { return (T*)((GNSListItem(T)*)_Access (n)); }			\
  T* operator [] (unsigned int n)					\
    { return (T*)((GNSListItem(T)*)_Access (n + 1)); }			\
  T* Prev (T* item) 							\
    { return (T*)((GNSListItem(T)*)_Prev ((GNSListItem(T)*)item)); }	\
  T* Next (T* item)							\
    { return (T*)((GNSListItem(T)*)_Next ((GNSListItem(T)*)item)); }	\
  T* Head () { return (T*)((GNSListItem(T)*)_Head ()); }		\
  T* Tail () { return (T*)((GNSListItem(T)*)_Tail ()); }		\
  void Push (T* item) { _Push ((GNSListItem(T)*)item); }		\
  void Push (GNSList(T)& list) { _Push (list); }			\
  T* Pop () { return (T*)((GNSListItem(T)*)_Pop ()); }			\
  void Inject (T* item) { _Inject ((GNSListItem(T)*)item); }		\
  void Inject (GNSList(T)& list) { _Inject (list); }			\
  T* Eject () { return (T*)((GNSListItem(T)*)_Eject ()); }		\
  void InsertBefore (T* item, unsigned int pos)				\
    { _InsertBefore ((GNSListItem(T)*)item, pos); }			\
  void InsertBefore (T* item, T* pos)					\
    { _InsertBefore ((GNSListItem(T)*)item, (GNSListItem(T)*)pos); }	\
  void InsertAfter (T* item, unsigned int pos)				\
    { _InsertAfter ((GNSListItem(T)*)item, pos); }			\
  void InsertAfter (T* item, T* pos)					\
    { _InsertAfter ((GNSListItem(T)*)item, (GNSListItem(T)*)pos); }	\
  void Delete (T* item) { _Delete ((GNSListItem(T)*)item); }		\
  void Delete (unsigned int pos) { _Delete (pos); }			\
  void Clear () { _Clear (); }						\
  void ExchangeItem (T* item, T* pos)					\
    { _ExchangeItem ((GNSListItem(T)*)item, (GNSListItem(T)*)pos); }	\
  void ExchangeItem (T* item, unsigned int pos)				\
    { _ExchangeItem ((GNSListItem(T)*)item, pos); }			\
  void SwapItem (T* i1, T* i2)						\
    { _SwapItem ((GNSListItem(T)*)i1, (GNSListItem(T)*)i2); }		\
  void SwapItem (unsigned int n1, unsigned int n2)			\
    { _SwapItem (n1, n2); }						\
};									\
									\
class GNSListIterator(T)						\
{									\
  _NSListIterator nsi;							\
 public:								\
  GNSListIterator(T) (GNSList(T)& l) : nsi(l) { ; }			\
  GNSListIterator(T) (GNSList(T)* l) : nsi(*l) { ; }			\
  T* operator () () { return (T *)((GNSListItem(T)*)nsi ()); }		\
  void Revert () { nsi.Revert (); }					\
};									\

#endif /* _leaf_nslist_h */
