// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xalist.h:
//
// eXogenous(OI) Array List
//
// class _XAList	void* version
// class XAList<T>	template version
// class GXAList(T)	generic macro version
//
// buffer -> [*][*][*][*][-][ ][ ]
//
// iterator 
// class _XAListIterator
// class XAListIterator<T>
// class GXAListIterator(T)
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xalist.h,v 1.4 1994/04/29 05:03:01 kudou Exp $

#ifndef _leaf_xalist_h
#define _leaf_xalist_h

#include "typedef.h"
#include "xlist.h"

// ݂͂̎@g߂Ƀobt@͏ɂP]vɊmۂ
// 邱Ƃۏ؂ĂB܂pɂɃobt@ĊmۂȂ
// ɁAĊmۂ̍ۂɗ]Ƀobt@mۂ

class _XAList 
: public _XList 
{
  // obt@
  void*(* buffer)[];
  
  // obt@̃TCY
  unsigned int buffer_size;
  
  // gp̃TCY
  unsigned int used_size;
  
  // ftHg̏obt@TCY
  enum { default_initial_buffer_size = 10 };
  
  // obt@̍Ċmۂ̍ۂ̗]mۃTCY
  enum { extra_realloc_size = 10 };
  
  // obt@̃TCYǗ
  void CheckBufferSize(unsigned int new_size);

public:
  // RXgN^
  _XAList();
  
  // RXgN^Aobt@TCY̎wt
  // initial_buffer_size : ߂̃obt@̑傫
  _XAList(unsigned int initial_buffer_size);
  
  // Rs[RXgN^
  _XAList(_XList& l);
  
  // fXgN^
  ~_XAList();
  
  // ۃNXpo
#  include "xlistm.h"
  
friend class _XAListIterator;
};

class _XAListIterator 
: public _XListIterator 
{
  // C^[gʒu
  unsigned int pos;
  
public:
  // RXgN^
  // l                 : C^[g
  _XAListIterator(_XList* l);
  
  // RXgN^
  // l                 : C^[g
  _XAListIterator(_XList& l);
  
  // ۃNXpo
# include "xlisti.h"
};

#ifdef HAS_TEMPLATE
template <class T>
class XAList
{
  friend class XAListIterator<T>; 
  _XAList apl;

 public:
  XAList() : apl() { ; }
  XAList(_XList& sl) : apl(sl) { ; }
  XAList(XAList<T>& sl) : apl(sl.apl) { ; }
  ~XAList() { ; }
  operator _XList& () { return apl; }
  void operator = (XAList<T>& l) { apl = l.apl; }
  bool EmptyP() { return apl.EmptyP(); }
  unsigned int Number() { return apl.Number(); }
  T* Access(unsigned int n) { return (T*)apl.Access(n); }
  T* operator [] (unsigned int n) { return (T*)apl.Access(n + 1); }
  T* Prev(T* item) { return (T*)apl.Prev(item); }
  T* Next(T* item) { return (T*)apl.Next(item); }
  T* Head() { return (T*)apl.Head(); }
  T* Tail() { return (T*)apl.Tail(); }
  void Push(T* item) { apl.Push(item); }
  T* Pop() { return (T*)apl.Pop(); }
  void Inject(T* item) { apl.Inject(item); }
  T* Eject() { return (T*)apl.Eject(); }
  void InsertBefore(T* item, unsigned int pos) 
    { apl.InsertBefore(item, pos); }
  void InsertBefore(T* item, T* pos)
    { apl.InsertBefore(item, pos); }
  void InsertAfter(T* item, unsigned int pos)
    { apl.InsertAfter(item, pos); }
  void InsertAfter(T* item, T* pos)
    { apl.InsertAfter(item, pos); }
  void Delete(T* pos) { apl.Delete(pos); }
  void Delete(unsigned int pos) { apl.Delete(pos); }
  void Clear() { apl.Clear(); }
  void ExchangeItem(T* item, unsigned int pos)
    { apl.ExchangeItem(item, pos); }
  void ExchangeItem(T* item, T* pos)
    { apl.ExchangeItem(item, pos); }
  void SwapItem(T* i1, T* i2)
    { apl.SwapItem(i1, i2); }
  void SwapItem(unsigned int n1, unsigned int n2)
    { apl.SwapItem(n1, n2); }
};

template <class T>
class XAListIterator
{
  _XAListIterator apli; 
 public:
  XAListIterator(_XList* l) : apli(l) { ; }
  XAListIterator(_XList& l) : apli(l) { ; }
  XAListIterator(XAList<T>* l) : apli(l->apl) { ; }
  T* operator () () { return (T*)apli(); }
  void Revert() { apli.Revert(); }
};
#endif

#include "generic.h"

// NX̒`
#define GXAList(T) name2(GXAList_,T)
#define GXAListIterator(T) name2(GXAListIterator_,T)

// NX錾
// ̃}N^ɂēWJ邱ƂŐNX`
// e\bhɂĂ̎dl _XAList, _XList ̃NXQƂ̂
#define GXAListDeclare(T)						\
class GXAList(T)							\
{									\
  _XAList apl;								\
 public:								\
  GXAList(T)() : apl() { ; }						\
  GXAList(T)(_XList& sl) : apl(sl) { ; }				\
  GXAList(T)(GXAList(T)& sl) : apl(sl.apl) { ; }			\
  ~GXAList(T)() { ; }							\
  operator _XList& () { return apl; }					\
  void operator = (GXAList(T)& l) { apl = l.apl; }			\
  bool EmptyP() { return apl.EmptyP(); }				\
  unsigned int Number() { return apl.Number(); }			\
  T* Access(unsigned int n) { return (T*)apl.Access(n); }		\
  T* operator [] (unsigned int n) { return (T*)apl.Access(n + 1); }	\
  T* Prev(T* item) { return (T*)apl.Prev(item); }			\
  T* Next(T* item) { return (T*)apl.Next(item); }			\
  T* Head() { return (T*)apl.Head(); }					\
  T* Tail() { return (T*)apl.Tail(); }					\
  void Push(T* item) { apl.Push(item); }				\
  T* Pop() { return (T*)apl.Pop(); }					\
  void Inject(T* item) { apl.Inject(item); }				\
  T* Eject() { return (T*)apl.Eject(); }				\
  void InsertBefore(T* item, unsigned int pos) 				\
    { apl.InsertBefore(item, pos); }					\
  void InsertBefore(T* item, T* pos)					\
    { apl.InsertBefore(item, pos); }					\
  void InsertAfter(T* item, unsigned int pos)				\
    { apl.InsertAfter(item, pos); }					\
  void InsertAfter(T* item, T* pos)					\
    { apl.InsertAfter(item, pos); }					\
  void Delete(T* pos) { apl.Delete(pos); }				\
  void Delete(unsigned int pos) { apl.Delete(pos); }			\
  void Clear() { apl.Clear(); }						\
  void ExchangeItem(T* item, unsigned int pos)				\
    { apl.ExchangeItem(item, pos); }					\
  void ExchangeItem(T* item, T* pos)					\
    { apl.ExchangeItem(item, pos); }					\
  void SwapItem(T* i1, T* i2)						\
    { apl.SwapItem(i1, i2); }						\
  void SwapItem(unsigned int n1, unsigned int n2)			\
    { apl.SwapItem(n1, n2); }						\
  friend class GXAListIterator(T); 					\
};									\
									\
class GXAListIterator(T) 						\
{									\
  _XAListIterator apli; 						\
 public:								\
  GXAListIterator(T)(_XList* l) : apli(l) { ; }				\
  GXAListIterator(T)(_XList& l) : apli(l) { ; }				\
  GXAListIterator(T)(GXAList(T)* l) : apli(l->apl) { ; }		\
  T* operator () () { return (T*)apli(); }				\
  void Revert() { apli.Revert(); }					\
};

#endif /* _leaf_xalist_h */
