// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xdlist.cc:
//
// eXogenous(OI) Double List
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xdlist.cc,v 1.4 1994/07/14 09:04:11 kudou Exp $

#include "config.h"
#include "xdlist.h"

// -------------------------------------------------------------------- //
// oOIXg̃m[h\
// -------------------------------------------------------------------- //
class _XDListNode 
{
  // Xgvf
  void* item;
  
  // Õm[h
  _XDListNode* prev;
  
  // ̃m[h
  _XDListNode* next;
  
 public:
  // CT[gȂ̃RXgN^
  _XDListNode (void* item, _XDListNode* prev, _XDListNode* next)
  {
    _XDListNode::item = item;
    prev->next = this;
    _XDListNode::prev = prev;
    next->prev = this;
    _XDListNode::next = next;
  }
  
  // RXgN^Asentinel ̐p
  _XDListNode ()
  {
    item = 0;
    prev = next = this;
  }
  
  // RXgN^ARs[RXgN^p
  // prev  next ͌ŃZbg
  _XDListNode (void* item) { _XDListNode::item = item; }
  
  // vf̎o
  void* GetItem () { return item; }
  
  // vf̐ݒ
  void SetItem (void* item) { _XDListNode::item = item; }
  
  // Õm[h̎o
  _XDListNode* GetPrev () { return prev; }
  
  // Õm[h̐ݒ
  void SetPrev (_XDListNode* prev) { _XDListNode::prev = prev; }
  
  // ̃m[h̎o
  _XDListNode* GetNext () { return next; }
  
  // ̃m[h̐ݒ
  void SetNext (_XDListNode* next) { _XDListNode::next = next; }
  
  // N̐؂
  void Unlink ()
  {
    prev->next = next;
    next->prev = prev;
  }
};

// -------------------------------------------------------------------- //
// class _XDList ̃\bh
// -------------------------------------------------------------------- //
inline _XDListNode*
_XDList::GetFirst ()
{
  return sentinel->GetNext ();
}

inline _XDListNode*
_XDList::GetLast ()
{
  return sentinel->GetPrev ();
}

_XDList::_XDList ()
{
  sentinel = new _XDListNode ();
}

_XDList::_XDList (_XList& l)
{
  sentinel = new _XDListNode ();
  if (l.GetXListID () == _XDListID)
  {
    _XDList& dpl = (_XDList&)l;
    _XDListNode* prev = sentinel;
    for (_XDListNode* node = dpl.GetFirst ();
	 node != dpl.sentinel;
	 node = node->GetNext ())
    {
      _XDListNode* new_node = new _XDListNode (node->GetItem ());
      prev->SetNext (new_node);
      new_node->SetPrev (prev);
      prev = new_node;
    }
    prev->SetNext (sentinel);
    sentinel->SetPrev (prev);
  }
  else
  {
    _XList::operator = (l);
  }
}

_XDList::~_XDList ()
{
  Clear ();
  delete sentinel;
}

void
_XDList::operator = (_XList& l)
{
  if (l.GetXListID () == _XDListID)
  {
    _XDList& dpl = (_XDList&)l;
    Clear ();
    _XDListNode* prev = sentinel;
    for (_XDListNode* node = dpl.GetFirst ();
	 node != dpl.sentinel;
	 node = node->GetNext ())
    {
      _XDListNode* new_node = new _XDListNode (node->GetItem ());
      prev->SetNext (new_node);
      new_node->SetPrev (prev);
      prev = new_node;
    }
    prev->SetNext (sentinel);
    sentinel->SetPrev (prev);
  }
  else
  {
    _XList::operator = (l);
  }
}

_XListID
_XDList::GetXListID ()
{
  return _XDListID;
}

bool
_XDList::EmptyP ()
{
  return (GetFirst () == sentinel) ? True : False;
}

unsigned int
_XDList::Number ()
{
  unsigned int num = 0;
  for (_XDListNode* node = GetFirst (); 
       node != sentinel;
       node = node->GetNext ())
  {
    num ++;
  }
  return num;
}

void*
_XDList::Access (unsigned int n)
{
  for (_XDListNode* node = GetFirst ();
       node != sentinel;
       node = node->GetNext ())
  {
    if (--n == 0)
    {
      return node->GetItem ();
    }
  }
  return 0;
}

void*
_XDList::operator [] (unsigned int n)
{
  return Access (n + 1);
}

void*
_XDList::Prev (void* item)
{
  sentinel->SetItem (item);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != item;
       node = node->GetNext ())
  {
    ;
  }
  if ((node != sentinel) && (node->GetPrev () != sentinel))
  {
    return node->GetPrev ()->GetItem ();
  }
  return 0;
}

void*
_XDList::Next (void* item)
{
  sentinel->SetItem (item);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != item;
       node = node->GetNext ())
  {
    ;
  }
  if ((node != sentinel) && (node->GetNext () != sentinel))
  {
    return node->GetNext ()->GetItem ();
  }
  return 0;
}

void*
_XDList::Head ()
{
  return (GetFirst () == sentinel) ? 0 : GetFirst ()->GetItem ();
}

void*
_XDList::Tail ()
{
  return (GetLast () == sentinel) ? 0 : GetLast ()->GetItem ();
}

void
_XDList::Push (void* item)
{
  new _XDListNode (item, sentinel, GetFirst ());
}

void*
_XDList::Pop ()
{
  _XDListNode* pop = GetFirst ();
  pop->Unlink ();
  void* ret = pop->GetItem ();
  delete pop;
  return ret;
}

void
_XDList::Inject (void* item)
{
  new _XDListNode (item, GetLast (), sentinel);
}

void*
_XDList::Eject ()
{
  _XDListNode* eject = GetLast ();
  eject->Unlink ();
  void* ret = eject->GetItem ();
  delete eject;
  return ret;
}

void
_XDList::InsertBefore (void* item, unsigned int pos)
{
  for (_XDListNode* node = GetFirst ();
       node != sentinel;
       node = node->GetNext ())
  {
    if (--pos == 0)
    {
      new _XDListNode (item, node->GetPrev (), node);
      return;
    }
  }
}

void
_XDList::InsertBefore (void* item, void* pos)
{
  sentinel->SetItem (pos);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    new _XDListNode (item, node->GetPrev (), node);
  }
}

void
_XDList::InsertAfter (void* item, unsigned int pos)
{
  for (_XDListNode* node = GetFirst ();
       node != sentinel;
       node = node->GetNext ())
  {
    if (--pos == 0)
    {
      new _XDListNode (item, node, node->GetNext ());
      return;
    }
  }
}

void
_XDList::InsertAfter (void* item, void* pos)
{
  sentinel->SetItem (pos);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    new _XDListNode (item, node, node->GetNext ());
  }
}

void
_XDList::Delete (void* pos)
{
  sentinel->SetItem (pos);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    node->Unlink ();
    delete node;
  }
}

void
_XDList::Delete (unsigned int pos)
{
  for (_XDListNode* node = GetFirst ();
       node != sentinel;
       node = node->GetNext ())
  {
    if (--pos == 0)
    {
      node->Unlink ();
      delete node;
      return;
    }
  }
}

void
_XDList::Clear ()
{
  _XDListNode* node = GetFirst ();
  while (node != sentinel)
  {
    _XDListNode* next = node->GetNext ();
    delete node;
    node = next;
  }
  sentinel->SetNext (sentinel);
  sentinel->SetPrev (sentinel);
}

void
_XDList::ExchangeItem (void* item, unsigned int pos)
{
  for (_XDListNode* node = GetFirst ();
       node != sentinel;
       node = node->GetNext ())
  {
    if (--pos == 0)
    {
      node->SetItem (item);
      return;
    }
  }
}

void
_XDList::ExchangeItem (void* item, void* pos)
{
  sentinel->SetItem (pos);
  for (_XDListNode* node = GetFirst ();
       node->GetItem () != pos;
       node = node->GetNext ())
  {
    ;
  }
  if (node != sentinel)
  {
    node->SetItem (item);
  }
}

void
_XDList::SwapItem (void* i1, void* i2)
{
  sentinel->SetItem (i1);
  for (_XDListNode* i1_node = GetFirst ();
       i1_node->GetItem () != i1;
       i1_node = i1_node->GetNext ())
  {
    ;
  }
  sentinel->SetItem (i2);
  for (_XDListNode* i2_node = GetFirst ();
       i2_node->GetItem () != i2;
       i2_node = i2_node->GetNext ())
  {
    ;
  }
  if ((i1_node != sentinel) && (i2_node != sentinel))
  {
    void* swap_buf = i1_node->GetItem ();
    i1_node->SetItem (i2_node->GetItem ());
    i2_node->SetItem (swap_buf);
  }
}

void
_XDList::SwapItem (unsigned int n1, unsigned int n2)
{
  for (_XDListNode* i1_node = GetFirst ();
       i1_node != sentinel;
       i1_node = i1_node->GetNext ())
  {
    if (--n1 == 0)
    {
      break;
    }
  }
  for (_XDListNode* i2_node = GetFirst ();
       i2_node != sentinel;
       i2_node = i2_node->GetNext ())
  {
    if (--n2 == 0)
    {
      break;
    }
  }
  if ((i1_node != sentinel) && (i2_node != sentinel))
  {
    void* swap_buf = i1_node->GetItem ();
    i1_node->SetItem (i2_node->GetItem ());
    i2_node->SetItem (swap_buf);
  }
}

#ifndef NODEBUG
extern "C"
{
#include <stdio.h>
}
void
_XDList::Show ()
{
  printf ("_XDListNode* sentinel :%p\n", sentinel);
  printf ("node list\n");
  for (_XDListNode* node = GetFirst (); 
       node != sentinel; 
       node = node->GetNext ())
  {
    printf ("node: %p [item:%p] next:%p prev:%p\n", 
	   node, node->GetItem (), node->GetNext (), node->GetPrev ());
  }
}

#endif /* NODEBUG */

// -------------------------------------------------------------------- //
// class _XDListIterator ̃\bh
// -------------------------------------------------------------------- //
_XDListIterator::_XDListIterator (_XList* l)
: _XListIterator (l)
{
  if (id == _XDListID)
  {
    node = ((_XDList*)l)->GetFirst ();
  }
  else
  {
    node = 0;
  }
}

_XDListIterator::_XDListIterator (_XList& l)
: _XListIterator (l)
{
  if (id == _XDListID)
  {
    node = ((_XDList*)&l)->GetFirst ();
  }
  else
  {
    node = 0;
  }
}

void*
_XDListIterator::operator () ()
{
  if (id == _XDListID)
  {
    if (node == ((_XDList*)l)->sentinel)
    {
      return 0;
    }
    else
    {
      void* ret = node->GetItem ();
      node = node->GetNext ();
      return ret;
    }
  }
  else
  {
    // Ώۂ _XDList łȂ
    return _XListIterator::operator () ();
  }
}

void
_XDListIterator::Revert ()
{
  if (id == _XDListID)
  {
    node = ((_XDList*)l)->sentinel;
  }
  else
  {
    // Ώۂ _XDList łȂ
    _XListIterator::Revert ();
  }
}
