// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xlist.cc:
//
// eXogenous(OI) void* List Base class
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xlist.cc,v 1.3 1994/04/28 18:36:01 kudou Exp $

#include "config.h"
#include "xlist.h"

_XList::_XList ()
{
}

_XList::~_XList ()
{
}

void
_XList::operator = (_XList& l)
{
  Clear ();
  for (void* item = l.Head (); item != 0; item = l.Next (item))
  {
    Inject (item);
  }
}

#ifndef NODEBUG
void
_XList::Show ()
{
}
#endif

_XListIterator::_XListIterator (_XList* l)
{
  _XListIterator::l = l;
  id = l->GetXListID ();
  current = 0;
}

_XListIterator::_XListIterator (_XList& l)
{
  _XListIterator::l = &l;
  id = l.GetXListID ();
  current = 0;
}

_XListIterator::~_XListIterator ()
{
}

void*
_XListIterator::operator () ()
{
  if (current == 0)
  {
    return current = l->Head ();
  }
  else
  {
    return current = l->Next (current);
  }
}

void
_XListIterator::Revert ()
{
  current = 0;
}
