// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xlist.h:
//
// eXogenous(OI) void* List Base class
//
// class _XList@@@@@: ۃNXuOIXgv
// class _XListIterator  : |C^̃C^[^
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xlist.h,v 1.2 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_xlist_h
#define _leaf_xlist_h

#include "typedef.h"

// OIXg̎ۂ̃NX\F邽߂̂hc
enum _XListID 
{
  _XSListID,  // VOOIXg
  _XDListID,  // _uOIXg
  _XAListID,  // TCYߔz
  _XTListID,  // Q
  _XMListID,  // 
};

// ۃNXuOIXgv
class _XList 
{
 public:
  
  // RXgN^
  _XList ();
  
  // fXgN^
  virtual ~_XList ();
  
  // ATCg
  virtual void operator = (_XList& l);
  
  // NX\Fhc𓾂
  // return            : hc
  virtual _XListID GetXListID () = 0;
  
  // 񂪋󂩂ǂ
  // return            : True: , False: vf
  virtual bool EmptyP () = 0;
  
  // ̗vf𓾂
  // return            : vf̐
  virtual unsigned int Number () = 0;
  
  // vf̎Q
  // n                 : ʒuiP`j
  // return            : vfAG[ȂOԂ
  virtual void* Access (unsigned int n) = 0;
  
  // vf̔zIȎQ
  // n                 : CfbNXiO`j
  // return            : vfAG[ȂOԂ
  virtual void* operator [] (unsigned int n) = 0;
  
  // PO̗vf𓾂
  // item              : ̗vf̂PO
  // return            : O̗vfAG[ȂOԂ
  virtual void* Prev (void* item) = 0;
  
  // P̗vf𓾂
  // item              : ̗vf̂P
  // return            : P̗vfAG[ȂOԂ
  virtual void* Next (void* item) = 0;
  
  // ̐擪vf𓾂
  // return            : 擪vfAG[ȂOԂ
  virtual void* Head () = 0;
  
  // ̖vf𓾂
  // return            : vfAG[ȂOԂ
  virtual void* Tail () = 0;
  
  // ̐擪ɗvf
  // item              : }vf
  virtual void Push (void* item) = 0;
  
  // ̐擪̗vfO
  // return            : oꂽvf
  virtual void* Pop () = 0;
  
  // ̖ɗvf
  // item              : }vf
  virtual void Inject (void* item) = 0;
  
  // ̖̗vfO
  // return            : oꂽvf
  virtual void* Eject () = 0;
  
  // O}
  // item              : }vf
  // pos               : }ʒuiP`j
  virtual void InsertBefore (void* item, unsigned int pos) = 0;
  
  // O}
  // item              : }vf
  // pos               : ̗vf̑Oɑ}
  virtual void InsertBefore (void* item, void* pos) = 0;
  
  // }
  // item              : }vf
  // pos               : }ʒuiP`j
  virtual void InsertAfter (void* item, unsigned int pos) = 0;
  
  // }
  // item              : }vf
  // pos               : ̗vf̌ɑ}
  virtual void InsertAfter (void* item, void* pos) = 0;
  
  // 폜
  // item              : 폜vf
  virtual void Delete (void* item) = 0;
  
  // 폜
  // pos               : ̈ʒu̗vf폜
  virtual void Delete (unsigned int pos) = 0;
  
  // ׂĂ̗vf̍폜
  virtual void Clear () = 0;
  
  // vf̕ύX
  // item              : Vvf̒l
  // pos               : ύXvf
  virtual void ExchangeItem (void* item, void* pos) = 0;
  
  // vf̕ύX
  // item              : Vvf̒l
  // pos               : ύXʒuiP`j
  virtual void ExchangeItem (void* item, unsigned int pos) = 0;
  
  // vf̌
  // i1, i2            : vf
  virtual void SwapItem (void* i1, void* i2) = 0;
  
  // vf̌
  // n1, n2            : ʒu
  virtual void SwapItem (unsigned int n1, unsigned int n2) = 0;
  
#ifndef NODEBUG
  // fobN\
  virtual void Show ();
#endif
};

// ۃNXuOIXgṽC^[^
class _XListIterator 
{
  // C^[g̈ʒu
  void* current;
  
 protected:
  // C^[guOIXgv
  _XList* l;
  
  // OIXg\
  _XListID id;
  
 public:
  // RXgN^
  // l                 : C^[g
  _XListIterator (_XList* l);
  
  // RXgN^
  // l                 : C^[g
  _XListIterator (_XList& l);
  
  // fXgN^
  virtual ~_XListIterator ();
  
  // C^[^AXɗ̗vfԂ
  // C^[gǏĂяoʂ͕s
  // return            : ̗vfAOԂ̏I
  virtual void* operator () ();
  
  // C^[V̂蒼
  virtual void Revert ();
};

typedef void (* show_func_t) (void*);

#endif /* _leaf_xlist_h */
