// -------------------------------------------------------------------- //
//                          Leaf class library
//           Copyright (c) 1992-4 by T.Kudou. All rights reserved.
//
// xslist.h:
//
// eXogenous(OI) Single List
//
// class _XSList	void* version
// class XSList<T>	template version
// class GXSList(T)	generic macro version
//
// first -->[*]-->[*]-->[*]-->...-->[*]-->[-] <-- sentinel
//
// iterator
// class _XSListIterator
// class XSListIterator<T>
// class GXSListIterator(T)
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/leaf/src/RCS/xslist.h,v 1.3 1994/07/14 09:04:11 kudou Exp $

#ifndef _leaf_xslist_h
#define _leaf_xslist_h

#include "typedef.h"
#include "xlist.h"

class _XSListNode; // forword ref.

// VOOIXg
class _XSList 
: public _XList 
{
  // ŏ̃Xgm[h
  _XSListNode* first;
  
  // ݂͂
  _XSListNode* sentinel;
  
 public:
  // RXgN^
  _XSList ();
  
  // Rs[RXgN^
  _XSList (_XList& sl);
  
  // fXgN^
  ~_XSList ();
  
  // ۃNXpo֐
#  include "xlistm.h"
  
  friend class _XSListIterator;
};

class _XSListIterator 
: public _XListIterator 
{
  // C^[g̃m[h
  _XSListNode* node;
  
 public:
  // RXgN^
  // l                 : C^[g
  _XSListIterator (_XList* l);
  
  // RXgN^
  // l                 : C^[g
  _XSListIterator (_XList& l);
  
  // ۃNXpo
#  include "xlisti.h"
};

#ifdef HAS_TEMPLATE
template <class T>
class XSList
{
  friend class XSListIterator<T>;
  _XSList spl;

 public:
  XSList() : spl() { ; }
  XSList(_XList& sl) : spl(sl) { ; }
  XSList(XSList<T>& sl) : spl(sl.spl) { ; }
  ~XSList() { ; }
  operator _XList& () { return spl; }
  void operator = (XSList<T>& l) { spl = l.spl; }
  bool EmptyP() { return spl.EmptyP(); }
  unsigned int Number() { return spl.Number(); }
  T* Access(unsigned int n) { return (T*)spl.Access(n); }
  T* operator [] (unsigned int n) { return (T*)spl.Access(n + 1); }
  T* Prev(T* item) { return (T*)spl.Prev(item); }
  T* Next(T* item) { return (T*)spl.Next(item); }
  T* Head() { return (T*)spl.Head(); }
  T* Tail() { return (T*)spl.Tail(); }
  void Push(T* item) { spl.Push(item); }
  T* Pop() { return (T*)spl.Pop(); }
  void Inject(T* item) { spl.Inject(item); }
  T* Eject() { return (T*)spl.Eject(); }
  void InsertBefore(T* item, unsigned int pos) 
     { spl.InsertBefore(item, pos); }
  void InsertBefore(T* item, T* pos)
     { spl.InsertBefore(item, pos); }
  void InsertAfter(T* item, unsigned int pos)
     { spl.InsertAfter(item, pos); }
  void InsertAfter(T* item, T* pos)
     { spl.InsertAfter(item, pos); }
  void Delete(T* pos) { spl.Delete(pos); }
  void Delete(unsigned int pos) { spl.Delete(pos); }
  void Clear() { spl.Clear(); }
  void ExchangeItem(T* item, unsigned int pos)
     { spl.ExchangeItem(item, pos); }
  void ExchangeItem(T* item, T* pos)
     { spl.ExchangeItem(item, pos); }
  void SwapItem(T* i1, T* i2)
     { spl.SwapItem(i1, i2); }
  void SwapItem(unsigned int n1, unsigned int n2)
     { spl.SwapItem(n1, n2); }
};

template <class T>
class XSListIterator
{
  _XSListIterator spli; 
 public:
  XSListIterator(_XList* l) : spli(l) { ; }
  XSListIterator(_XList& l) : spli(l) { ; }
  XSListIterator(XSList<T>* l) : spli(l->spl) { ; }
  T* operator () () { return (T*)spli(); }
  void Revert() { spli.Revert(); }
};
#endif /* HAS_TEMPLATE */

#include "generic.h"

// NX̒`
#define GXSList(T) name2(GXSList_,T)
#define GXSListIterator(T) name2(GXSListIterator_,T)

// NX錾
// ̃}N^ɂēWJ邱ƂŐNX`
// e\bhɂĂ̎dl _XSList, _XList ̃NXQƂ̂
#define GXSListDeclare(T)						\
class GXSList(T)							\
{									\
  friend class GXSListIterator(T); 					\
  _XSList spl;								\
 public:								\
  GXSList(T)() : spl() { ; }						\
  GXSList(T)(_XList& sl) : spl(sl) { ; }				\
  GXSList(T)(GXSList(T)& sl) : spl(sl.spl) { ; }			\
  ~GXSList(T)() { ; }							\
  operator _XList& () { return spl; }					\
  void operator = (GXSList(T)& l) { spl = l.spl; }			\
  bool EmptyP() { return spl.EmptyP(); }				\
  unsigned int Number() { return spl.Number(); }			\
  T* Access(unsigned int n) { return (T*)spl.Access(n); }		\
  T* operator [] (unsigned int n) { return (T*)spl.Access(n + 1); }	\
  T* Prev(T* item) { return (T*)spl.Prev(item); }			\
  T* Next(T* item) { return (T*)spl.Next(item); }			\
  T* Head() { return (T*)spl.Head(); }					\
  T* Tail() { return (T*)spl.Tail(); }					\
  void Push(T* item) { spl.Push(item); }				\
  T* Pop() { return (T*)spl.Pop(); }					\
  void Inject(T* item) { spl.Inject(item); }				\
  T* Eject() { return (T*)spl.Eject(); }				\
  void InsertBefore(T* item, unsigned int pos) 				\
     { spl.InsertBefore(item, pos); }					\
  void InsertBefore(T* item, T* pos)					\
     { spl.InsertBefore(item, pos); }					\
  void InsertAfter(T* item, unsigned int pos)				\
     { spl.InsertAfter(item, pos); }					\
  void InsertAfter(T* item, T* pos)					\
     { spl.InsertAfter(item, pos); }					\
  void Delete(T* pos) { spl.Delete(pos); }				\
  void Delete(unsigned int pos) { spl.Delete(pos); }			\
  void Clear() { spl.Clear(); }						\
  void ExchangeItem(T* item, unsigned int pos)				\
     { spl.ExchangeItem(item, pos); }					\
  void ExchangeItem(T* item, T* pos)					\
     { spl.ExchangeItem(item, pos); }					\
  void SwapItem(T* i1, T* i2)						\
     { spl.SwapItem(i1, i2); }						\
  void SwapItem(unsigned int n1, unsigned int n2)			\
     { spl.SwapItem(n1, n2); }						\
};									\
									\
class GXSListIterator(T) 						\
{									\
  _XSListIterator spli; 						\
 public:								\
  GXSListIterator(T)(_XList* l) : spli(l) { ; }				\
  GXSListIterator(T)(_XList& l) : spli(l) { ; }				\
  GXSListIterator(T)(GXSList(T)* l) : spli(l->spl) { ; }		\
  T* operator () () { return (T*)spli(); }				\
  void Revert() { spli.Revert(); }					\
};

#endif /* _leaf_xslist_h */
