// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// mdisamp.h
//
// MDI sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/sample/mdisamp/RCS/mdisamp.h,v 1.3 1994/03/25 18:32:53 kudou Exp $

#ifndef _mdisamp_h
#define _mdisamp_h

class MdiSample
: public MdiFrameWnd
{
  enum { border_size = 6 };
  StatusWnd* status_wnd;

 protected:
  virtual void Display (HDC hdc);
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual void OpenChildWindow ();
  virtual LPSTR GetCaptionStr ();
  virtual LPSTR GetMenuName ();
  StatusWnd* GetStatusWnd () { return status_wnd; }
  uword Menu (WPARAM wparam, LPARAM lparam);
  virtual HMENU GetWindowMenu ();

  uword Cascade (bool menu_state);
  uword Arrange (bool menu_state);
  uword Tile (bool menu_state);
 public:
  MdiSample ();
  ~MdiSample ();

  MdiChildWnd* OpenMdiChildWindow ();
};

#define MENU_ID_OPEN    101
#define MENU_ID_EXIT    102
#define MENU_ID_ABOUT   103
#define MENU_ID_CASCADE 114
#define MENU_ID_ARRANGE 115
#define MENU_ID_TILE    116

#endif /* _mdisamp_h */
