// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// term.h:
//
// class TerminalWnd
// class TtySetDlg
//
// terminal sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/0/lw/sample/term/RCS/term.h,v 1.3 1994/05/05 16:30:20 kudou Exp $

#ifndef _leaf_term_h
#define _leaf_term_h

class TerminalWnd
: public BaseWnd
{
  static bool register_flag;
  TermWnd* term_wnd;
  StatusWnd* status_wnd;
  enum { border_size = 6 };
  
 public:
  TerminalWnd ();
  ~TerminalWnd ();
  TermWnd* GetTermWnd () { return term_wnd; }
  StatusWnd* GetStatusWnd () { return status_wnd; }
  
 protected:
  virtual bool RegisterFlag ();
  virtual void SetRegisterFlag ();
  virtual LPSTR GetMenuName ();
  virtual HANDLE GetIcon ();
  virtual LPSTR GetCaptionStr ();
  virtual void OpenChildWindow ();
  virtual uword Menu (WPARAM wparam, LPARAM lparam);
  virtual void Display (HDC dc);
  virtual void SetFocus ();
  virtual void Resize (WORD left, WORD top, WORD right, WORD bottom);
  virtual long WindowProc (UINT msg, WPARAM wparam, LPARAM lparam);
  
 private:
  uword Connect (bool menu_state);
  uword Close (bool menu_state);
  uword ComSet (bool menu_state);
  uword Exit (bool menu_state);
  uword About (bool menu_state);
  void MenuSelect (WPARAM wparam);
};

class TtySetDlg
: public ModalDlg
{
  TermWnd* term_wnd;
  Comm& comm;
 public:
  TtySetDlg (TermWnd* term_wnd);
  ~TtySetDlg ();
  
 protected:
  virtual BOOL WmCommand (WPARAM wparam);
  virtual BOOL WmInitDialog ();
  void Fixed ();
};

// menu ID
#define MENU_ID_CONNECT	101
#define MENU_ID_CLOSE   102
#define MENU_ID_COMSET	103
#define MENU_ID_EXIT	104
#define MENU_ID_ABOUT	105

// TtySetDlg ID
#define TTYSETDLG_300	101
#define TTYSETDLG_1200	102
#define TTYSETDLG_2400	103
#define TTYSETDLG_4800	104
#define TTYSETDLG_9600	105
#define TTYSETDLG_14400	106
#define TTYSETDLG_19200	107
#define TTYSETDLG_38400	108
#define TTYSETDLG_56000	109
#define TTYSETDLG_128000 110
#define TTYSETDLG_256000 111
#define TTYSETDLG_BIT7	112
#define TTYSETDLG_BIT8	113
#define TTYSETDLG_X	114
#define TTYSETDLG_HARD	115
#define TTYSETDLG_FNORN	116
#define TTYSETDLG_STOP1	117
#define TTYSETDLG_STOP15 118
#define TTYSETDLG_STOP2	119
#define TTYSETDLG_PNORN	120
#define TTYSETDLG_ODD	121
#define TTYSETDLG_EVEN	122
#define TTYSETDLG_COM1	123
#define TTYSETDLG_COM2	124
#define TTYSETDLG_COM3	125
#define TTYSETDLG_COM4	126
#define TTYSETDLG_CN_RECEIVE 127

// string ID
#define MENU_MSG_OFFSET 100
#define MSG_ID_CONNECT MENU_ID_CONNECT + MENU_MSG_OFFSET
#define MSG_ID_CLOSE   MENU_ID_CLOSE + MENU_MSG_OFFSET
#define MSG_ID_COMSET  MENU_ID_COMSET + MENU_MSG_OFFSET
#define MSG_ID_EXIT    MENU_ID_EXIT + MENU_MSG_OFFSET
#define MSG_ID_ABOUT   MENU_ID_ABOUT + MENU_MSG_OFFSET

#define STR_ID_TERM	301
#define STR_ID_EXIT	302
#define STR_ID_ABOUT	303

#endif /* _leaf_term_h */
