// -------------------------------------------------------------------- //
//                     Leaf class library for Windows
//           Copyright (c) 1993-4 by T.Kudou. All rights reserved.
//
// simple.cpp:
//
// toolbar window sample
// -------------------------------------------------------------------- //
// $Header: /d/1/proj/egypt/1/lw/sample/toolbar/RCS/simple.cpp,v 1.6 1994/07/17 15:04:44 kudou Exp $

#include "lw.h"
#include "simple.h"
#include <math.h>
#include <string.h>

const int ProfButtonSize = 100;

ProfileEntry prof_ent [] =
{ // entry     default  id
  { "BUTTON0", "btn0", 0 },
  { "BUTTON1", "btn1", 1 },
  { "BUTTON2", "btn2", 2 },
  { "BUTTON3", "btn3", 3 },
  { "BUTTON4", "btn4", 4 },
  { "BUTTON5", "btn5", 5 },
  { "BUTTON6", "btn6", 6 },
  { "BUTTON7", "btn7", 7 },
  { "BUTTON8", "btn8", 8 },
  { "BUTTON9", "btn9", 9 },
  //
  { "BUTTONSIZE", "auto", ProfButtonSize },
  { 0, 0, 0 }
};

// {^rbg}bvƃj[ID̑Ή
ButtonMenuId button_menu_id [] =
{
  { "btn0", MENU_ID_1_1 },
  { "btn1", MENU_ID_1_2 },
  { "btn2", MENU_ID_1_3 },
  { "btn3", MENU_ID_1_4 },
  { "btn4", MENU_ID_2_1 },
  { "btn5", MENU_ID_2_2 },
  { "btn6", MENU_ID_2_3 },
  { "btn7", MENU_ID_2_4 },
  0,
};

Simple::Simple ()
: profile ("TOOLBAR-TEST", "FOO.INI", prof_ent)
{
  tool_bar = 0;
  status_wnd = 0;
}

LPSTR
Simple::GetCaptionStr ()
{
  return "Simple";
}

void 
Simple::Display (HDC hdc)
{
  DisplayGrayFrame (hdc, border_size);
  
  int x_size = GetWindowXSize ();
  int y_size = GetWindowYSize ();
  const double pi = 3.14159265;
  const double delta = pi / 250.0;
  
  int px = x_size / 2;
  int py = y_size / 2;
  int wx = x_size * 2 / 5;
  int wy = y_size * 2 / 5;
  int x1, y1, x2, y2;
  for (double a = 0.0; a < pi; a += delta)
  {
    x1 = px - wx * cos(0.8 * a);
    y1 = py - wy * sin(7.0 * a) * cos(a / 2.5);
    x2 = px - wx * cos(1.2 * a);
    y2 = y1;
    ::MoveTo(hdc, x1, y1);
    ::LineTo(hdc, x2, y2);
  }
}

void
Simple::OpenChildWindow ()
{
  tool_bar = new ToolBarWnd (this);
  // button size ݒ
  char* prof_button_size = profile.GetEntry (ProfButtonSize);
  if (strcmp (prof_button_size, "auto"))
  {
    if (!strcmp (prof_button_size, "small"))
    {
      tool_bar->SetToolButtonSize (SmallBtn);
    }
    else if (!strcmp (prof_button_size, "middle"))
    {
      tool_bar->SetToolButtonSize (MiddleBtn);
    }
    else if (!strcmp (prof_button_size, "large"))
    {
      tool_bar->SetToolButtonSize (LargeBtn);
    }
  }
  // button ̓o^
  for (int i = 0; i <= 9; i++)
  {
    char* bttn_name = profile.GetEntry (i);
    tool_bar->AddButton (bttn_name,
			 ButtonMenuId::GetMenuId (button_menu_id,
						  bttn_name));
  }
  tool_bar->OpenWindow ();

  status_wnd = new StatusWnd (this);
  status_wnd->OpenWindow ();
}

void
Simple::Resize (WORD left, WORD top, WORD right, WORD bottom)
{
  if (tool_bar)
  {
    tool_bar->MoveWindow (border_size,
			  border_size,
			  right - left - border_size,
			  border_size + tool_bar->GetToolBarHeight ());
  }
  if (status_wnd)
  {
    status_wnd->MoveWindow (border_size,
			    (bottom - top - border_size - 
			     status_wnd->GetBarHeight ()),
			    right - left - border_size,
			    bottom - top - border_size);
  }
}

long 
Simple::WindowProc (UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
   case WM_CLOSE:
    Close ();
    break;
   
   case WM_DESTROY:
    Destroy ();
    break;
    
   case WM_MENUSELECT:
    MenuSelect (wparam);
    break;

   default:
    return BaseWnd::WindowProc (msg, wparam, lparam);
  }
  return 0L;
}

void
Simple::Close ()
{
  ::DestroyWindow (GetHandle ());
}
  
void
Simple::Destroy ()
{
  ::PostQuitMessage (0);
}

LPSTR
Simple::GetMenuName ()
{
  return "SimpleMenu";
}

void
Simple::MenuSelect (WPARAM wparam)
{
  switch (wparam)
  {
   case MENU_ID_1_1:
   case MENU_ID_1_2:
   case MENU_ID_1_3:
   case MENU_ID_1_4:
   case MENU_ID_2_1:
   case MENU_ID_2_2:
   case MENU_ID_2_3:
   case MENU_ID_2_4:
   case MENU_ID_3_1:
   case MENU_ID_3_2:
   case MENU_ID_3_3:
   case MENU_ID_3_4:
    status_wnd->Printf ("MENU %d-%d", wparam / 100, wparam % 100);
    break;
   default:
    status_wnd->ClearMsg ();
    break;
  }
}

uword
Simple::Menu (WPARAM wparam, LPARAM lparam)
{
  if (lparam == GET_MENU_STATE)
  {
    return MF_ENABLED;
  }
  
  switch (wparam)
  {
   case MENU_ID_1_1:
   case MENU_ID_1_2:
   case MENU_ID_1_3:
   case MENU_ID_1_4:
   case MENU_ID_2_1:
   case MENU_ID_2_2:
   case MENU_ID_2_3:
   case MENU_ID_2_4:
   case MENU_ID_3_1:
   case MENU_ID_3_2:
   case MENU_ID_3_3:
   case MENU_ID_3_4:
    MessageBoxPrintf ("MENU %d-%d selected.", "Menu", MB_ICONEXCLAMATION,
		      wparam / 100, wparam % 100);
    break;
   default:
    break;
  }
  return 0;
}

int
Main ()
{
  Simple wnd;
  wnd.OpenWindow ();
  return MSWin::MessageLoop ();
}
